package com.xdja.fwzxutils.base;

import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;

import com.blankj.utilcode.util.Utils;
import com.xdja.fwzxutils.utils.ErrorCallBack;

import io.reactivex.internal.operators.maybe.MaybeErrorCallable;
import okhttp3.logging.HttpLoggingInterceptor;

/**
 * @author yuanwanli
 * @des 服务总线mdm平台注册应用基本信息
 * @date 2020/9/23
 */
public class BaseInfoUtils {
    /**
     * 集中管控id
     */
    public static String controlId;
    /**
     * 集中管控name
     */
    public static String controlName;
    /**
     * 应用id
     */
    private static String appId;
    /**
     * 应用地区id
     */
    private static String orgId;
    /**
     * 应用网络类型
     */
    private static String networkAreaCode;
    /**
     * gprs获取权限接口
     */
    private static String gprsPowerId;
    /**
     * gprs登录接口
     */
    private static String gprsLoginResId;
    /**
     * gprs业务接口
     */
    private static String gprsBusinessResId;
    /**
     * serviceBus联网日志级别
     */
    private static HttpLoggingInterceptor.Level serviceBusHttpLevel = HttpLoggingInterceptor.Level.BODY;
    private static ErrorCallBack errorCallBack;
    public static HttpLoggingInterceptor.Level getServiceBusHttpLevel() {
        return serviceBusHttpLevel;
    }

    public static void setServiceBusHttpLevel(HttpLoggingInterceptor.Level serviceBusHttpLevel) {
        BaseInfoUtils.serviceBusHttpLevel = serviceBusHttpLevel;
    }

    public static ErrorCallBack getErrorCallBack() {
        return errorCallBack;
    }

    public static void setErrorCallBack(ErrorCallBack errorCallBack) {
        BaseInfoUtils.errorCallBack = errorCallBack;
    }

    /**
     * 设置集中管控信息
     *
     * @param controlId   集中管控id
     * @param controlName 集中管控name
     * @return
     */
    public static void setControlInfo(String controlId, String controlName) {
        BaseInfoUtils.controlId = controlId;
        BaseInfoUtils.controlName = controlName;
    }

    public static void setGprsInfo(String gprsLoginResId, String gprsBusinessResId, String gprsPowerId) {
        BaseInfoUtils.gprsLoginResId = gprsLoginResId;
        BaseInfoUtils.gprsBusinessResId = gprsBusinessResId;
        BaseInfoUtils.gprsPowerId = gprsPowerId;
    }

    public static String getAppId() {
        if (appId != null) {
            return appId;
        }
        try {
            ApplicationInfo applicationInfo = Utils.getApp().getPackageManager().getApplicationInfo(Utils.getApp().getPackageName(), PackageManager.GET_META_DATA);
            appId = applicationInfo.metaData.getString("appId", "");
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return appId;
    }


    public static String getOrgId() {
        if (orgId != null) {
            return orgId;
        }
        try {
            ApplicationInfo applicationInfo = Utils.getApp().getPackageManager().getApplicationInfo(Utils.getApp().getPackageName(), PackageManager.GET_META_DATA);
            orgId = applicationInfo.metaData.getString("regionalismCode", "");
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return orgId;
    }

    public static String getNetworkAreaCode() {
        if (networkAreaCode != null) {
            return networkAreaCode;
        }
        try {
            ApplicationInfo applicationInfo = Utils.getApp().getPackageManager().getApplicationInfo(Utils.getApp().getPackageName(), PackageManager.GET_META_DATA);
            networkAreaCode = applicationInfo.metaData.getString("networkCode", "");
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return networkAreaCode;
    }

    public static String getGprsLoginResId() {
        return gprsLoginResId;
    }

    public static String getGprsBusinessResId() {
        return gprsBusinessResId;
    }

    public static String getGprsPowerId() {
        return gprsPowerId;
    }
}
