package com.xdja.fwzxutils.base;

import android.text.TextUtils;

import com.blankj.utilcode.util.CacheDoubleStaticUtils;
import com.xdja.fwzxutils.bean.ResourceQueryBean;
import com.xdja.fwzxutils.bean.ResourceResponseBean;
import com.xdja.fwzxutils.exception.CustomThrowable;
import com.xdja.fwzxutils.exception.TimeoutException;
import com.xdja.fwzxutils.net.RetrofitFactory;
import com.xdja.fwzxutils.utils.ErrorCallBack;

import java.io.IOException;

import io.reactivex.ObservableEmitter;
import io.reactivex.annotations.NonNull;

/**
 * @author yuanwanli
 * @des
 * @date 2020/11/30
 */
class BaseRequest {
    protected ResourceResponseBean getResponse(ObservableEmitter e,ResourceQueryBean queryBean, String tag) throws IOException {
        String resourceId = queryBean.getParameter().getDataObjId();
        if (TextUtils.isEmpty(resourceId)) {
            String errorMessage = "resourceId为空";
            DefaultFormatPrinter.printRequest(queryBean, errorMessage, tag);
            e.onError(new Throwable(errorMessage));
            return null;
        }
        String url = CacheDoubleStaticUtils.getString(resourceId);
        queryBean.getHeads().add("messageId : " + queryBean.getMessageId());
        queryBean.getHeads().add("resourceId : " + resourceId);
        queryBean.getHeads().add("url : " + url);
        if (url == null || url.isEmpty()) {
            String errorMessage = "联网请求失败,请求地址为空";
            DefaultFormatPrinter.printRequest(queryBean, errorMessage, tag);
            e.onError(new Throwable(errorMessage));
            return null;
        }
        DefaultFormatPrinter.printRequest(queryBean, null, tag);
        // 执行网络请求
        ResourceResponseBean responseBean = RetrofitFactory.getInstance().getServiceBusApi().getRequest(url, queryBean).execute().body();
        if (responseBean == null) {
            String errorMessage = "联网请求失败,ResourceResponseBean为空";
            DefaultFormatPrinter.printResponse(null, null, errorMessage, tag);
            e.onError(new Throwable(errorMessage));
        }
        return responseBean;
    }
    public void dealErrorInfo(ObservableEmitter e, ResourceResponseBean responseBean, String tag) {
        String errorMessage = responseBean.getMessage();
        DefaultFormatPrinter.printResponse(null, null, errorMessage, tag);
        ErrorCallBack errorCallBack = BaseInfoUtils.getErrorCallBack();
        if (responseBean.isTimeout()){
            TimeoutException timeoutException = new TimeoutException();
            if (errorCallBack!=null){
                errorCallBack.onError(timeoutException);
            }
            e.onError(timeoutException);
        }else {
            CustomThrowable customThrowable = new CustomThrowable(responseBean.getCode(), errorMessage);
            if (errorCallBack!=null){
                errorCallBack.onError(customThrowable);
            }
            e.onError(customThrowable);
        }
    }
}
