package com.xdja.fwzxutils.base;

import android.text.TextUtils;
import android.util.Log;

import com.blankj.utilcode.util.GsonUtils;
import com.blankj.utilcode.util.ThreadUtils;
import com.xdja.fwzxutils.bean.ResourceQueryBean;
import com.xdja.fwzxutils.common.Constant;
import com.xdja.fwzxutils.utils.CharacterUtils;
import com.xdja.fwzxutils.utils.MyTask;

import java.util.Collections;
import java.util.List;

/**
 * @author yuanwanli
 * @des 默认日志打印
 * @date 2020/10/13
 */
public class DefaultFormatPrinter {
    private static final String Get_Credential_Head =
            "┌─────────────────────────────── 获取凭证 ───────────────────────────────┐";
    private static final String Get_ResourceAddress_Head =
            "┌──────────────────────────────── 寻址 ────────────────────────────────┐";
    private static final String Get_GPRS_Request_Head =
            "┌───────────────────────────── GPRServer 请求 ──────────────────────────────┐";
    private static final String Get_Request_Head =
            "┌────────────────────────────── 服务总线请求 ──────────────────────────────┐";
    private static final String Get_GPRS_Response_Head =
            "┌───────────────────────────── GPRServer 返回 ──────────────────────────────┐";
    private static final String Get_Response_Head =
            "┌────────────────────────────── 服务总线返回 ──────────────────────────────┐";
    private static final String Base_Foot =
            "└───────────────────────────────────────────────────────────────────┘";
    private static final String MainRequestTag =
            "├ 重要入参(messageId对应返回的messageId)";
    private static final String MainResponseTag =
            "├ 重要出参";
    private static final String AllGprServerRequestTag =
            "├ gprs完整入参 ";
    private static final String AllGprServerResponseTag =
            "├ gprs完整出参 ";
    private static final String AllRequestTag =
            "├ 完整入参 ";
    private static final String AllResponseTag =
            "├ 完整出参 ";
    private static final String RequestTag =
            "├ 入参 ";
    private static final String ResponseTag =
            "├ 出参 ";
    private static final String CORNER_UP = "┌ ";
    private static final String CORNER_BOTTOM = "└ ";
    private static final String CENTER_LINE = "├ ";
    private static final String DEFAULT_LINE = "│ ";

    /**
     * 打印获取凭证
     *
     * @param request        请求内容
     * @param appCredential  应用凭证
     * @param userCredential 用户凭证
     * @param errorMessage   错误信息
     */
    public static void printGetCredential(List<String> request, String appCredential, String userCredential, String errorMessage) {
        Log.d(Constant.TAG, Get_Credential_Head);
        Log.d(Constant.TAG, RequestTag);
        logLines(request);
        Log.d(Constant.TAG, ResponseTag);
        if (!TextUtils.isEmpty(appCredential)) {
            Log.d(Constant.TAG, DEFAULT_LINE + "appCredential : " + CharacterUtils.jsonFormat(appCredential));
        }
        if (!TextUtils.isEmpty(userCredential)) {
            Log.d(Constant.TAG, DEFAULT_LINE + "userCredential : " + CharacterUtils.jsonFormat(userCredential));
        }
        if (!TextUtils.isEmpty(errorMessage)) {
            Log.d(Constant.TAG, DEFAULT_LINE + "错误信息 : " + errorMessage);
        }
        Log.d(Constant.TAG, Base_Foot);
    }

    /**
     * 打印寻址
     *
     * @param request      请求内容
     * @param response     返回内容
     * @param errorMessage 错误信息
     */
    public static void printGetResourceAddress(List<String> request, String response, String errorMessage) {
        Log.d(Constant.TAG, Get_ResourceAddress_Head);
        Log.d(Constant.TAG, RequestTag);
        logLines(request);
        Log.d(Constant.TAG, ResponseTag);
        if (!TextUtils.isEmpty(response)) {
            Log.d(Constant.TAG, DEFAULT_LINE + CharacterUtils.jsonFormat(response));
        }
        if (!TextUtils.isEmpty(errorMessage)) {
            Log.d(Constant.TAG, DEFAULT_LINE + "错误信息 : " + errorMessage);
        }
        Log.d(Constant.TAG, Base_Foot);
    }

    /**
     * 打印请求服务总线内容
     *
     * @param queryBean    请求bean
     * @param errorMessage 错误信息
     * @param tag          标识 xml，json
     */
    public static void printRequest(ResourceQueryBean queryBean, String errorMessage, String tag) {
        final MyTask myTask=new MyTask() {
            @Override
            public String doInBackground() throws Throwable {
                List<String> heads = queryBean.getHeads();
                Collections.reverse(heads);
                if (Constant.XML_DATA.equals(tag)) {
                    Log.d(Constant.TAG, Get_GPRS_Request_Head);
                    Log.d(Constant.TAG, MainRequestTag);
                    logLines(heads);
                    Log.d(Constant.TAG, AllGprServerRequestTag);
                    String xmlValue = queryBean.getParameter().getCondition().getKeyValueList().get(0).getValue();
                    logLine(CharacterUtils.xmlFormat(xmlValue));
                } else {
                    Log.d(Constant.TAG, Get_Request_Head);
                    Log.d(Constant.TAG, MainRequestTag);
                    logLines(heads);
                    Log.d(Constant.TAG, AllRequestTag);
                    logLine(CharacterUtils.jsonFormat(GsonUtils.toJson(queryBean)));
                }
                if (errorMessage != null) {
                    Log.d(Constant.TAG, DEFAULT_LINE + "请求出错 : " + errorMessage);
                }
                Log.d(Constant.TAG, Base_Foot);
                return super.doInBackground();
            }
        };
        ThreadUtils.executeBySingle(myTask);
    }

    /**
     * 打印相应服务总线内容
     *
     * @param heads        头部信息
     * @param response     响应内容
     * @param errorMessage 错误信息
     * @param tag          标识 xml，json
     */
    public static void printResponse(List<String> heads, String response, String errorMessage, String tag) {
        final MyTask myTask=new MyTask() {
            @Override
            public String doInBackground() throws Throwable {
                if (Constant.XML_DATA.equals(tag)) {
                    Log.d(Constant.TAG, Get_GPRS_Response_Head);
                    if (heads != null) {
                        Log.d(Constant.TAG, MainResponseTag);
                        logLines(heads);
                    }
                    if (errorMessage != null) {
                        Log.d(Constant.TAG, DEFAULT_LINE + "请求出错 : " + errorMessage);
                    }
                    Log.d(Constant.TAG, AllGprServerResponseTag);
                    if (!TextUtils.isEmpty(response)) {
                        logLine(CharacterUtils.xmlFormat(response));
                    } else {
                        Log.d(Constant.TAG, DEFAULT_LINE + "无");
                    }
                } else {
                    Log.d(Constant.TAG, Get_Response_Head);
                    if (heads != null) {
                        Log.d(Constant.TAG, MainResponseTag);
                        logLines(heads);
                    }
                    if (errorMessage != null) {
                        Log.d(Constant.TAG, DEFAULT_LINE + "请求出错 : " + errorMessage);
                    }
                    Log.d(Constant.TAG, AllResponseTag);
                    if (!TextUtils.isEmpty(response)) {
                        logLine(CharacterUtils.jsonFormat(response));
                    } else {
                        Log.d(Constant.TAG, DEFAULT_LINE + "无");
                    }
                }
                Log.d(Constant.TAG, Base_Foot);
                return super.doInBackground();
            }
        };
        ThreadUtils.executeBySingle(myTask);
    }

    private static void logLines(List<String> lines) {
        for (String line : lines) {
            int lineLength = line.length();
            int maxLongSize = 110;
            for (int i = 0; i <= lineLength / maxLongSize; i++) {
                int start = i * maxLongSize;
                int end = (i + 1) * maxLongSize;
                end = Math.min(end, line.length());
                Log.d(Constant.TAG, DEFAULT_LINE + line.substring(start, end));
            }
        }
    }
    private static void logLine(String line) {
        int lineLength = line.length();
        int maxLongSize = 4000;
        for (int i = 0; i <= lineLength / maxLongSize; i++) {
            int start = i * maxLongSize;
            int end = (i + 1) * maxLongSize;
            end = Math.min(end, line.length());
            Log.d(Constant.TAG, DEFAULT_LINE + line.substring(start, end));
        }
    }
}
