package com.xdja.fwzxutils.exception;

import android.text.TextUtils;

public class CustomThrowable extends Throwable {
    private final String DEFAULT_CODE = this.getClass().getSimpleName() + "_DefaultCode";
    private String code;

    public CustomThrowable(String code) {
        this.code = this.DEFAULT_CODE;
        if (!TextUtils.isEmpty(code)) {
            this.code = code;
        }
    }

    public CustomThrowable(String code, String detailMessage) {
        super(detailMessage);
        this.code = this.DEFAULT_CODE;
        if (!TextUtils.isEmpty(code)) {
            this.code = code;
        }

    }

    public CustomThrowable(String code, String detailMessage, Throwable throwable) {
        super(detailMessage, throwable);
        this.code = this.DEFAULT_CODE;
        if (!TextUtils.isEmpty(code)) {
            this.code = code;
        }

    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String toString() {
        return "code : " + this.code + "\r\n" + super.toString();
    }
}
