package com.xdja.fwzxutils.net;

import android.text.TextUtils;

import com.xdja.fwzxutils.base.BaseInfoUtils;
import com.xdja.fwzxutils.net.api.ServiceBusApi;

import java.net.URLEncoder;
import java.util.concurrent.TimeUnit;

import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

/**
 * @author 袁万里
 * 服务总线请求相关的RetrofitFactory
 * @date 2020/9/22
 */
public class RetrofitFactory {
    public final static long CONNECT_TIMEOUT = 30;
    public final static long READ_TIMEOUT = 30;
    public final static long WRITE_TIMEOUT = 30;
    public static RetrofitFactory INSTANCE = null;
    public static String appCredential;
    public static String userCredential;
    private final Object monitor = new Object();
    private final OkHttpClient client;
    private ServiceBusApi serviceBusApi;


    private RetrofitFactory() {
        //初始化OkHttp
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor();
        loggingInterceptor.level(BaseInfoUtils.getServiceBusHttpLevel());
        client = new OkHttpClient.Builder()
                .addInterceptor(chain -> {
                    Request.Builder builder = chain.request().newBuilder();
                    if (!TextUtils.isEmpty(userCredential)) {
                        builder.addHeader("userCredential", URLEncoder.encode(userCredential, "UTF-8"));
                    }
                    if (!TextUtils.isEmpty(appCredential)) {
                        builder.addHeader("appCredential", URLEncoder.encode(appCredential, "UTF-8"));
                    }
                    return chain.proceed(builder.build());
                })
                .addInterceptor(loggingInterceptor)
                .connectTimeout(CONNECT_TIMEOUT, TimeUnit.SECONDS)
                .readTimeout(READ_TIMEOUT, TimeUnit.SECONDS)
                .writeTimeout(WRITE_TIMEOUT, TimeUnit.SECONDS)
                .build();
    }

    public static RetrofitFactory getInstance() {
        if (INSTANCE == null) {
            synchronized (RetrofitFactory.class) {
                if (INSTANCE == null) {
                    INSTANCE = new RetrofitFactory();
                }
            }
        }
        return INSTANCE;
    }

    public ServiceBusApi getServiceBusApi() {
        if (serviceBusApi == null) {
            synchronized (monitor) {
                if (serviceBusApi == null) {
                    serviceBusApi = new Retrofit.Builder()
                            .baseUrl("http://127.0.0.1:8110/")
                            .addCallAdapterFactory(RxJava2CallAdapterFactory.create())
                            .addConverterFactory(GsonConverterFactory.create())
                            .client(client)
                            .build()
                            .create(ServiceBusApi.class);
                }
            }
        }
        return serviceBusApi;
    }
}
