/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.fwzxutils.base;

import com.blankj.utilcode.util.GsonUtils;
import com.xdja.fwzxutils.base.BaseRequest;
import com.xdja.fwzxutils.base.DefaultFormatPrinter;
import com.xdja.fwzxutils.bean.ResourceQueryBean;
import com.xdja.fwzxutils.bean.ResourceResponseBean;
import io.reactivex.Observable;
import io.reactivex.annotations.NonNull;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class BaseHttpRequest
extends BaseRequest {
    private BaseHttpRequest() {
    }

    public static BaseHttpRequest getInstance() {
        return Holder.singleton;
    }

    public <ResponseType> Observable<List<ResponseType>> getListOfType(@NonNull ResourceQueryBean queryBean, @NonNull String tag, @NonNull Class<ResponseType> classOfT) {
        return this.getResponse(queryBean, tag).flatMap(response -> Observable.create(e -> {
            try {
                Type listType = GsonUtils.getListType((Type)classOfT);
                List powers = (List)GsonUtils.fromJson((String)response, (Type)listType);
                if (powers == null) {
                    e.onError(new Throwable("json\u89e3\u6790\u5b57\u6bb5\u5931\u8d25"));
                } else {
                    e.onNext((Object)powers);
                    e.onComplete();
                }
            }
            catch (Throwable throwable) {
                e.onError(throwable);
            }
        }));
    }

    public Observable<List<ResourceResponseBean.DataBean.DataListBean>> getResponse(@NonNull ResourceQueryBean queryBean) {
        return Observable.create(e -> {
            try {
                ResourceResponseBean responseBean = super.getResponse(e, queryBean, null);
                if (responseBean != null) {
                    String messageId = responseBean.getMessageId();
                    ArrayList<String> heads = new ArrayList<String>();
                    heads.add("messageId : " + messageId);
                    if (responseBean.isSuccess().booleanValue()) {
                        DefaultFormatPrinter.printResponse(heads, GsonUtils.toJson(responseBean.getData().getDataList()), null, null);
                        e.onNext(responseBean.getData().getDataList());
                        e.onComplete();
                    } else {
                        this.dealErrorInfo(e, responseBean, null);
                    }
                }
            }
            catch (Throwable throwable) {
                e.onError(throwable);
            }
        });
    }

    public Observable<String> getResponse(@NonNull ResourceQueryBean queryBean, @NonNull String tag) {
        return Observable.create(e -> {
            try {
                ResourceResponseBean responseBean = super.getResponse(e, queryBean, tag);
                if (responseBean != null) {
                    String messageId = responseBean.getMessageId();
                    ArrayList<String> heads = new ArrayList<String>();
                    heads.add("messageId : " + messageId);
                    if (responseBean.isSuccess().booleanValue()) {
                        List<ResourceResponseBean.DataBean.DataListBean> dataList = responseBean.getData().getDataList();
                        String response = null;
                        if (dataList != null && dataList.size() > 0) {
                            List<ResourceResponseBean.DataBean.DataListBean.FieldValuesBean> fieldValues = dataList.get(0).getFieldValues();
                            for (ResourceResponseBean.DataBean.DataListBean.FieldValuesBean bean : fieldValues) {
                                if (!tag.equals(bean.getField())) continue;
                                response = bean.getValue();
                                break;
                            }
                            if (response == null) {
                                String errorMessage = "\u89e3\u6790\u5b57\u6bb5\u5931\u8d25,\u7ea6\u5b9a\u8fd4\u56de\u4e3a\u7a7a";
                                DefaultFormatPrinter.printResponse(null, null, errorMessage, tag);
                                e.onError(new Throwable(errorMessage));
                            } else {
                                DefaultFormatPrinter.printResponse(heads, response, null, tag);
                                e.onNext(response);
                                e.onComplete();
                            }
                        } else {
                            String errorMessage = "\u89e3\u6790\u5b57\u6bb5\u5931\u8d25,dataList\u5b57\u6bb5\u4e3a\u7a7a";
                            DefaultFormatPrinter.printResponse(null, null, errorMessage, tag);
                            e.onError(new Throwable(errorMessage));
                        }
                    } else {
                        this.dealErrorInfo(e, responseBean, tag);
                    }
                }
            }
            catch (Throwable throwable) {
                e.onError(throwable);
            }
        });
    }

    private static class Holder {
        private static BaseHttpRequest singleton = new BaseHttpRequest();

        private Holder() {
        }
    }
}

