/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.fwzxutils.base;

import android.text.TextUtils;
import com.blankj.utilcode.util.CacheDoubleStaticUtils;
import com.xdja.fwzxutils.base.BaseInfoUtils;
import com.xdja.fwzxutils.base.DefaultFormatPrinter;
import com.xdja.fwzxutils.bean.ResourceQueryBean;
import com.xdja.fwzxutils.bean.ResourceResponseBean;
import com.xdja.fwzxutils.exception.CustomThrowable;
import com.xdja.fwzxutils.exception.TimeoutException;
import com.xdja.fwzxutils.net.RetrofitFactory;
import com.xdja.fwzxutils.utils.ErrorCallBack;
import io.reactivex.ObservableEmitter;
import java.io.IOException;

class BaseRequest {
    BaseRequest() {
    }

    protected ResourceResponseBean getResponse(ObservableEmitter e, ResourceQueryBean queryBean, String tag) throws IOException {
        String resourceId = queryBean.getParameter().getDataObjId();
        if (TextUtils.isEmpty((CharSequence)resourceId)) {
            String errorMessage = "resourceId\u4e3a\u7a7a";
            DefaultFormatPrinter.printRequest(queryBean, errorMessage, tag);
            e.onError(new Throwable(errorMessage));
            return null;
        }
        String url = CacheDoubleStaticUtils.getString((String)resourceId);
        queryBean.getHeads().add("messageId : " + queryBean.getMessageId());
        queryBean.getHeads().add("resourceId : " + resourceId);
        queryBean.getHeads().add("url : " + url);
        if (url == null || url.isEmpty()) {
            String errorMessage = "\u8054\u7f51\u8bf7\u6c42\u5931\u8d25,\u8bf7\u6c42\u5730\u5740\u4e3a\u7a7a";
            DefaultFormatPrinter.printRequest(queryBean, errorMessage, tag);
            e.onError(new Throwable(errorMessage));
            return null;
        }
        DefaultFormatPrinter.printRequest(queryBean, null, tag);
        ResourceResponseBean responseBean = (ResourceResponseBean)RetrofitFactory.getInstance().getServiceBusApi().getRequest(url, queryBean).execute().body();
        if (responseBean == null) {
            String errorMessage = "\u8054\u7f51\u8bf7\u6c42\u5931\u8d25,ResourceResponseBean\u4e3a\u7a7a";
            DefaultFormatPrinter.printResponse(null, null, errorMessage, tag);
            e.onError(new Throwable(errorMessage));
        }
        return responseBean;
    }

    public void dealErrorInfo(ObservableEmitter e, ResourceResponseBean responseBean, String tag) {
        String errorMessage = responseBean.getMessage();
        DefaultFormatPrinter.printResponse(null, null, errorMessage, tag);
        ErrorCallBack errorCallBack = BaseInfoUtils.getErrorCallBack();
        if (responseBean.isTimeout()) {
            TimeoutException timeoutException = new TimeoutException();
            if (errorCallBack != null) {
                errorCallBack.onError(timeoutException);
            }
            e.onError((Throwable)timeoutException);
        } else {
            CustomThrowable customThrowable = new CustomThrowable(responseBean.getCode(), errorMessage);
            if (errorCallBack != null) {
                errorCallBack.onError(customThrowable);
            }
            e.onError((Throwable)customThrowable);
        }
    }
}

