/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.servicebus.http;

import com.jakewharton.retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import com.xdja.servicebus.http.api.UrlConverterApi;
import com.xdja.servicebus.http.cache.Cache;
import com.xdja.servicebus.http.cache.LruCache;
import com.xdja.servicebus.utils.UrlConstant;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class RetrofitFactory {
    public static final long CONNECT_TIMEOUT = 30L;
    public static final long READ_TIMEOUT = 30L;
    public static final long WRITE_TIMEOUT = 30L;
    private final Object monitor = new Object();
    public static RetrofitFactory INSTANCE = null;
    private final OkHttpClient client;
    private HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor();
    private UrlConverterApi urlConverterApi;
    private Cache<String, Object> mRetrofitServiceCache;

    private RetrofitFactory() {
        this.loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        this.client = new OkHttpClient.Builder().addInterceptor((Interceptor)this.loggingInterceptor).connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RetrofitFactory getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<RetrofitFactory> clazz = RetrofitFactory.class;
        synchronized (RetrofitFactory.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new RetrofitFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UrlConverterApi getUrlConverterApi() {
        if (this.urlConverterApi == null) {
            Object object = this.monitor;
            synchronized (object) {
                if (this.urlConverterApi == null) {
                    this.urlConverterApi = (UrlConverterApi)new Retrofit.Builder().baseUrl(this.getBaseUrl(UrlConverterApi.class)).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.client).build().create(UrlConverterApi.class);
                }
            }
        }
        return this.urlConverterApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getApiService(Class<T> service) {
        if (this.mRetrofitServiceCache == null) {
            this.mRetrofitServiceCache = new LruCache<String, Object>(100);
        }
        Cache<String, Object> cache = this.mRetrofitServiceCache;
        synchronized (cache) {
            Object retrofitService = this.mRetrofitServiceCache.get(service.getName());
            if (retrofitService == null) {
                Object object = this.monitor;
                synchronized (object) {
                    if (retrofitService == null) {
                        retrofitService = new Retrofit.Builder().baseUrl(this.getBaseUrl(service)).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.client).build().create(service);
                        this.mRetrofitServiceCache.put(service.getName(), retrofitService);
                    }
                }
            }
            return (T)retrofitService;
        }
    }

    private <T> String getBaseUrl(Class<T> service) {
        if (service.getName() == UrlConverterApi.class.getName()) {
            return UrlConstant.getSearchResourceUrl();
        }
        return UrlConstant.getSearchResourceUrl();
    }
}

