/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.servicebus.provider;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.blankj.utilcode.util.LogUtils;
import com.google.gson.Gson;
import com.xdja.servicebus.db.entity.RequestUrlEntity;
import com.xdja.servicebus.db.entity.UrlEntity;
import com.xdja.servicebus.http.RetrofitFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Headers;
import retrofit2.Call;
import retrofit2.Response;

public class ServiceBusProvider
extends ContentProvider {
    private static final String AUTHORITY = "com.ydjw.rsb.getResourceAddress";
    private static UriMatcher mUriMatcher = new UriMatcher(-1);
    private static final int URL_DIR = 0;
    private static final String VERSION = "version";
    private static final String MESSAGE_ID = "messageId";
    private static final String APP_CREDENTIAL = "appCredential";

    public boolean onCreate() {
        LogUtils.e((Object[])new Object[]{"onCreate"});
        return true;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return null;
    }

    public String getType(Uri uri) {
        throw new IllegalArgumentException("unknown uri" + uri.toString());
    }

    public Uri insert(Uri uri, ContentValues values) {
        return uri;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        return 0;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        return 0;
    }

    @Nullable
    public synchronized Bundle call(@NonNull String method, @Nullable String arg, @Nullable Bundle extras) {
        String version = extras.getString(VERSION);
        String appCredential = extras.getString(APP_CREDENTIAL);
        String messageId = extras.getString(MESSAGE_ID);
        int resultVersion = 0;
        Bundle bundle = new Bundle();
        try {
            appCredential = URLEncoder.encode(appCredential, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            bundle.putInt(VERSION, resultVersion);
            bundle.putString("message", "appCredential encode\u5931\u8d25\uff0c" + e.getMessage());
            bundle.putString(MESSAGE_ID, messageId);
            bundle.putInt("resultCode", 41000);
            bundle.putString("resourceList", null);
        }
        ArrayList<RequestUrlEntity> list = new ArrayList<RequestUrlEntity>();
        Call<List<UrlEntity>> url = RetrofitFactory.getInstance().getUrlConverterApi().getUrls(appCredential, messageId, version, list);
        try {
            resultVersion = Integer.parseInt(version);
            Response execute = url.execute();
            List body = (List)execute.body();
            Headers headers = execute.headers();
            if (headers != null) {
                bundle.putInt(VERSION, resultVersion);
                String resultMessageId = headers.get(MESSAGE_ID);
                bundle.putString(MESSAGE_ID, resultMessageId);
                String code = headers.get("code");
                bundle.putInt("resultCode", Integer.parseInt(code));
                String message = headers.get("message");
                bundle.putString("message", message);
                if (body != null) {
                    String json = new Gson().toJson((Object)body);
                    String result = json.replace("regionalismCode", "resourceRegionalismCode");
                    bundle.putString("resourceList", result);
                } else {
                    bundle.putString("resourceList", null);
                }
            } else {
                bundle.putInt(VERSION, resultVersion);
                bundle.putString("message", "\u670d\u52a1\u5668\u8bf7\u6c42\u5931\u8d25");
                bundle.putInt("resultCode", 41000);
                bundle.putString(MESSAGE_ID, messageId);
                bundle.putString("resourceList", null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            bundle.putInt(VERSION, resultVersion);
            if (TextUtils.isEmpty((CharSequence)e.getMessage())) {
                bundle.putString("message", "\u8bf7\u6c42\u5931\u8d25:" + e);
            } else {
                bundle.putString("message", "\u8bf7\u6c42\u5931\u8d25:" + e.getMessage());
            }
            bundle.putString(MESSAGE_ID, messageId);
            bundle.putInt("resultCode", 41000);
            bundle.putString("resourceList", null);
        }
        return bundle;
    }

    static {
        mUriMatcher.addURI(AUTHORITY, null, 0);
    }
}

