/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.servicebus.provider;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.NetworkOnMainThreadException;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.Gson;
import com.xdja.servicebus.http.RetrofitFactory;
import com.xdja.servicebus.http.entity.RequestUrlEntity;
import com.xdja.servicebus.http.entity.UrlEntity;
import com.xdja.servicebus.utils.UrlConstant;
import java.io.EOFException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import okhttp3.Headers;
import retrofit2.Call;
import retrofit2.Response;

public class ServiceBusProvider
extends ContentProvider {
    private static final String AUTHORITY = "com.ydjw.rsb.getResourceAddress";
    private static UriMatcher mUriMatcher = new UriMatcher(-1);
    private static final int URL_DIR = 0;
    private static final String VERSION = "version";
    private static final String MESSAGE_ID = "messageId";
    private static final String APP_CREDENTIAL = "appCredential";

    public boolean onCreate() {
        Log.d((String)"ServiceBusProvider", (String)"onCreate");
        return true;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return null;
    }

    public String getType(Uri uri) {
        throw new IllegalArgumentException("unknown uri" + uri.toString());
    }

    public Uri insert(Uri uri, ContentValues values) {
        return uri;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        return 0;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        return 0;
    }

    public synchronized Bundle call(String method, String arg, final Bundle extras) {
        final CountDownLatch downLatch = new CountDownLatch(1);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final Bundle bundle = new Bundle();
        executorService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String version = extras.getString(ServiceBusProvider.VERSION);
                String appCredential = extras.getString(ServiceBusProvider.APP_CREDENTIAL);
                String messageId = extras.getString(ServiceBusProvider.MESSAGE_ID);
                int resultVersion = 0;
                try {
                    appCredential = URLEncoder.encode(appCredential, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    bundle.putInt(ServiceBusProvider.VERSION, resultVersion);
                    bundle.putString("message", "\u5e94\u7528\u51ed\u8bc1 encode\u5931\u8d25:" + e.getMessage());
                    bundle.putString(ServiceBusProvider.MESSAGE_ID, messageId);
                    bundle.putInt("resultCode", 41002);
                    bundle.putString("resourceList", null);
                }
                ArrayList<RequestUrlEntity> list = new ArrayList<RequestUrlEntity>();
                String url = UrlConstant.getRsbSearchResourceUrl();
                Call<List<UrlEntity>> call = RetrofitFactory.getInstance().getUrlConverterApi().queryResourceAddress(url, appCredential, messageId, version, list);
                try {
                    resultVersion = Integer.parseInt(version);
                    Response execute = call.execute();
                    List body = (List)execute.body();
                    Headers headers = execute.headers();
                    if (headers != null) {
                        bundle.putInt(ServiceBusProvider.VERSION, resultVersion);
                        String resultMessageId = headers.get(ServiceBusProvider.MESSAGE_ID);
                        bundle.putString(ServiceBusProvider.MESSAGE_ID, resultMessageId);
                        String code = headers.get("code");
                        bundle.putInt("resultCode", Integer.parseInt(code));
                        String message = headers.get("message");
                        bundle.putString("message", message);
                        if (body != null) {
                            String json = new Gson().toJson((Object)body);
                            String result = json.replace("regionalismCode", "resourceRegionalismCode");
                            bundle.putString("resourceList", result);
                        } else {
                            bundle.putString("resourceList", null);
                        }
                    } else {
                        bundle.putInt(ServiceBusProvider.VERSION, resultVersion);
                        bundle.putString("message", "\u670d\u52a1\u5668\u8bf7\u6c42\u5931\u8d25,\u8bf7\u68c0\u67e5\u7f51\u7edc\u6216\u8005sod\u670d\u52a1:" + UrlConstant.getRsbSearchResourceUrl());
                        bundle.putInt("resultCode", 41003);
                        bundle.putString(ServiceBusProvider.MESSAGE_ID, messageId);
                        bundle.putString("resourceList", null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    bundle.putInt(ServiceBusProvider.VERSION, resultVersion);
                    String message = "\u672a\u77e5\u5f02\u5e38";
                    if (e instanceof NumberFormatException) {
                        bundle.putInt("resultCode", 41004);
                        message = "\u5bfb\u5740\u4f20\u5165\u7684version\u4e0d\u662f\u963f\u62c9\u4f2f\u6570\u5b57";
                    } else if (e instanceof NetworkOnMainThreadException) {
                        bundle.putInt("resultCode", 41001);
                        message = "\u4e3b\u7ebf\u7a0b\u8c03\u7528\u5bfb\u5740\uff0c\u6539\u4e3a\u5b50\u7ebf\u7a0b\u8c03\u7528";
                    } else if (e instanceof SocketTimeoutException || e instanceof ConnectException) {
                        bundle.putInt("resultCode", 41003);
                        message = "\u670d\u52a1\u5668\u8bf7\u6c42\u5931\u8d25,\u8bf7\u68c0\u67e5\u7f51\u7edc\u6216\u8005sod\u670d\u52a1:" + UrlConstant.getRsbSearchResourceUrl();
                    } else if (e instanceof EOFException) {
                        bundle.putInt("resultCode", 41005);
                        message = "\u8bf7\u6c42\u5bfb\u5740\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5e94\u7528\u51ed\u8bc1\u662f\u5426\u89c4\u8303\uff0c\u9519\u8bef\u4fe1\u606f:" + e;
                    } else {
                        message = TextUtils.isEmpty((CharSequence)e.getMessage()) ? "\u8bf7\u6c42\u5931\u8d25:" + e : "\u8bf7\u6c42\u5931\u8d25:" + e.getMessage();
                        bundle.putInt("resultCode", 41000);
                    }
                    bundle.putString("message", message);
                    bundle.putString(ServiceBusProvider.MESSAGE_ID, messageId);
                    bundle.putString("resourceList", null);
                }
                finally {
                    downLatch.countDown();
                }
            }
        });
        executorService.shutdown();
        try {
            downLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return bundle;
    }

    static {
        mUriMatcher.addURI(AUTHORITY, null, 0);
    }
}

