package com.xdja.servicebus;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.util.Log;

import com.xdja.servicebus.utils.UrlConstant;

/**
 * @author jarlen
 * Create by 2023/4/22 16:22
 */
public class ServiceBusManager {

    public static final String TAG = ServiceBusManager.class.getSimpleName();

    /**
     * 资源服务寻址接口(寻址客户端提供)
     */
    private static final String PROVIDER_URI_GET_RESOURCE_ADDRESS = "com.ydjw.rsb.getResourceAddress";

    /**
     * 初始化服务总线插件
     *
     * @param context  应用上下文
     * @param isRsbNew 是否是新服务总线服务
     * @param ip       服务总线服务IP
     * @param port     服务总线服务Port
     * @param isHttps  服务总线服务请求协议
     */
    public static void initRSBSdk(Context context, boolean isRsbNew, String ip, String port, boolean isHttps) {
        if (!isSupportRsbProvider(context)) {
            Log.w(TAG, " not found rsb provider uri");
            return;
        }
        try {
            UrlConstant.setSearchResourceUrl(isHttps ? "https" : "http", ip, port, isRsbNew);
        } catch (Exception e) {
            Log.w(TAG, " initRSBSdk fail !" + e);
        }
        Log.i(TAG, "rsb server url = " + UrlConstant.getRsbSearchResourceUrl());
    }

    /**
     * 是否支撑RSB插件服务
     *
     * @param context
     * @return
     */
    private static boolean isSupportRsbProvider(Context context) {
        String rsbProviderPackageName = getCredentialProviderPackageName(context, PROVIDER_URI_GET_RESOURCE_ADDRESS);
        return context.getPackageName().equals(rsbProviderPackageName);
    }

    /**
     * 查询ContentProvider的Authority所在应用的包名
     *
     * @param context           应用上下文
     * @param providerAuthority ContentProvider的Authority
     * @return 应用包名
     */
    private static String getCredentialProviderPackageName(Context context, String providerAuthority) {
        PackageManager packageManager = context.getPackageManager();
        ProviderInfo providerInfo = packageManager.resolveContentProvider(providerAuthority, PackageManager.GET_META_DATA);
        return providerInfo == null ? "" : providerInfo.packageName;
    }
}