package com.xdja.servicebus.http;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;


/**
 * Author:kongguoguang
 * Date:2017-05-02
 * Time:11:26
 * Summary:
 */
public class OkHttp3Util {

    private static final int READ_TIMEOUT = 30;
    private static final int CONNECT_TIMEOUT = 10;
    private static final int WRITE_TIMEOUT = 10;
    private static OkHttpClient okHttpClient;

    public static OkHttpClient getTrustAllOkHttpClient() {
        if (okHttpClient == null) {
            okHttpClient = createOkHttpClient();
        }
        return okHttpClient;
    }

    private static OkHttpClient createOkHttpClient() {
        SSLContext sslContext;
        try {
            sslContext = SSLContext.getInstance("SSL");
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("获取sslContext异常", e);
        }
        if (sslContext == null) {
            throw new RuntimeException("sslContext == null");
        }

        TrustAllCertsManager trustAllCertsManager = new TrustAllCertsManager();
        TrustAllHostnameVerifier hostnameVerifier = new TrustAllHostnameVerifier();

        try {
            sslContext.init(null, new TrustManager[]{trustAllCertsManager}, new SecureRandom());
        } catch (KeyManagementException e) {
            throw new RuntimeException("SSLContext初始化异常", e);
        }

        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor();
        loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);

        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(CONNECT_TIMEOUT, TimeUnit.SECONDS)
                .readTimeout(READ_TIMEOUT, TimeUnit.SECONDS)
                .writeTimeout(WRITE_TIMEOUT, TimeUnit.SECONDS)
                .sslSocketFactory(sslContext.getSocketFactory(), trustAllCertsManager)
                .hostnameVerifier(hostnameVerifier)
                .connectionPool(new ConnectionPool(0, 5, TimeUnit.MILLISECONDS))
                .addInterceptor(loggingInterceptor);
        return builder.build();
    }

    private static class TrustAllCertsManager implements X509TrustManager {
        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (chain == null && authType == null) {
                throw new CertificateException();
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (chain == null && authType == null) {
                throw new CertificateException();
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private static class TrustAllHostnameVerifier implements HostnameVerifier {

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}
