package com.xdja.servicebus.http;

import com.xdja.servicebus.http.api.UrlConverterApi;

import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;


/**
 * @author 袁万里
 * @date 2017/5/31 0031
 */

public class RetrofitFactory {

    public static RetrofitFactory INSTANCE = null;
    private UrlConverterApi urlConverterApi;

    private RetrofitFactory() {
    }

    public static RetrofitFactory getInstance() {
        if (INSTANCE == null) {
            synchronized (RetrofitFactory.class) {
                if (INSTANCE == null) {
                    INSTANCE = new RetrofitFactory();
                }
            }
        }
        return INSTANCE;
    }

    public UrlConverterApi getUrlConverterApi() {
        if (urlConverterApi == null) {
            synchronized (RetrofitFactory.class) {
                if (urlConverterApi == null) {
                    urlConverterApi = new Retrofit.Builder()
                            .baseUrl("http://www.baidu.com/")
                            .addConverterFactory(GsonConverterFactory.create())
                            .client(OkHttp3Util.getTrustAllOkHttpClient())
                            .build()
                            .create(UrlConverterApi.class);
                }
            }
        }
        return urlConverterApi;
    }
}
