package com.xdja.servicebus.utils;

import android.net.Uri;
import android.text.TextUtils;

/**
 * @author yuanwanli
 * @des
 * @date 2019/4/9
 */
public class UrlConstant {
    public static final String URL_Service_Default = "";
    public static String URL_Rsb_Service_Url;

    public static void setSODSearchResourceUrl(String ip, String port) throws Exception {
        String url = "http://" + ip + ":" + port + "/sod/";
        UrlConstant.setRsbSearchResourceUrl(url);
    }

    public static void setSearchResourceUrl(boolean isRsb, String rsbUrl) throws Exception {
        Uri rsbServerUri = Uri.parse(rsbUrl);
        String url = rsbServerUri.getScheme() + "://" + rsbServerUri.getHost() + ":" + rsbServerUri.getPort() + (isRsb ? "/rsb/" : "/sod/");
        UrlConstant.setRsbSearchResourceUrl(url);
    }

    /**
     * 设置服务总线地址
     *
     * @param scheme 请求协议(https或http)
     * @param ip     服务IP
     * @param port   服务Port
     * @param isRsb  是否是服务总线服务
     * @throws Exception
     */
    public static void setSearchResourceUrl(String scheme, String ip, String port, boolean isRsb) throws Exception {
        String url = scheme + "://" + ip + ":" + port + (isRsb ? "/rsb/" : "/sod/");
        UrlConstant.setRsbSearchResourceUrl(url);
    }

    public static String getRsbSearchResourceUrl() {
        if (!TextUtils.isEmpty(URL_Rsb_Service_Url)) {
            return URL_Rsb_Service_Url;
        }
        return URL_Service_Default;
    }

    /**
     * 设置资源寻址服务地址，以"/"结尾，到服务名即可。
     * <br>例如:http://ip:port/sod/或者http://ip:port/rsb/<br/>
     *
     * @param rsbUrl 资源寻址服务地址
     *               <br>例如:http://ip:port/sod/或者http://ip:port/rsb/<br/>
     * @throws Exception
     */
    public static void setRsbSearchResourceUrl(String rsbUrl) throws Exception {
        if (TextUtils.isEmpty(rsbUrl)) {
            throw new Exception("rsbUrl is null");
        }
        rsbUrl = (rsbUrl.endsWith("/") ? rsbUrl : (rsbUrl + "/")) + "api/rsb/v1/queryResourceAddress";
        URL_Rsb_Service_Url = rsbUrl;
    }
}
