/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.servicebus;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.util.Log;
import com.xdja.servicebus.utils.UrlConstant;

public class ServiceBusManager {
    public static final String TAG = ServiceBusManager.class.getSimpleName();
    private static final String PROVIDER_URI_GET_RESOURCE_ADDRESS = "com.ydjw.rsb.getResourceAddress";

    public static void initRSBSdk(Context context, boolean isRsbNew, String ip, String port, boolean isHttps) {
        if (!ServiceBusManager.isSupportRsbProvider(context)) {
            Log.w((String)TAG, (String)" not found rsb provider uri");
            return;
        }
        try {
            UrlConstant.setSearchResourceUrl(isHttps ? "https" : "http", ip, port, isRsbNew);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)(" initRSBSdk fail !" + e));
        }
        Log.i((String)TAG, (String)("rsb server url = " + UrlConstant.getRsbSearchResourceUrl()));
    }

    private static boolean isSupportRsbProvider(Context context) {
        String rsbProviderPackageName = ServiceBusManager.getCredentialProviderPackageName(context, PROVIDER_URI_GET_RESOURCE_ADDRESS);
        return context.getPackageName().equals(rsbProviderPackageName);
    }

    private static String getCredentialProviderPackageName(Context context, String providerAuthority) {
        PackageManager packageManager = context.getPackageManager();
        ProviderInfo providerInfo = packageManager.resolveContentProvider(providerAuthority, 128);
        return providerInfo == null ? "" : providerInfo.packageName;
    }
}

