/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.servicebus.provider;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.NetworkOnMainThreadException;
import android.text.TextUtils;
import android.util.Log;
import com.alibaba.fastjson.JSON;
import com.xdja.servicebus.http.RetrofitFactory;
import com.xdja.servicebus.http.entity.RequestUrlEntity;
import com.xdja.servicebus.http.entity.UrlEntity;
import com.xdja.servicebus.utils.UrlConstant;
import java.io.EOFException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import okhttp3.Headers;
import retrofit2.Call;
import retrofit2.Response;

public class ServiceBusProvider
extends ContentProvider {
    private static final String AUTHORITY = "com.ydjw.rsb.getResourceAddress";
    private static UriMatcher mUriMatcher = new UriMatcher(-1);
    private static final int URL_DIR = 0;
    private static final String VERSION = "version";
    private static final String MESSAGE_ID = "messageId";
    private static final String APP_CREDENTIAL = "appCredential";
    private static final String RESOURCE_LIST = " resourceList";

    public boolean onCreate() {
        Log.d((String)"ServiceBusProvider", (String)"onCreate");
        return true;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return null;
    }

    public String getType(Uri uri) {
        throw new IllegalArgumentException("unknown uri" + uri.toString());
    }

    public Uri insert(Uri uri, ContentValues values) {
        return uri;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        return 0;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        return 0;
    }

    public synchronized Bundle call(String method, String arg, final Bundle extras) {
        final CountDownLatch downLatch = new CountDownLatch(1);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final Bundle bundle = new Bundle();
        executorService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String version = extras.getString(ServiceBusProvider.VERSION);
                String appCredential = extras.getString(ServiceBusProvider.APP_CREDENTIAL);
                String messageId = extras.getString(ServiceBusProvider.MESSAGE_ID);
                String resourceList = extras.getString(ServiceBusProvider.RESOURCE_LIST, "");
                int resultVersion = 0;
                try {
                    Call<List<UrlEntity>> call;
                    Response execute;
                    appCredential = URLEncoder.encode(appCredential, "UTF-8");
                    resultVersion = Integer.parseInt(version);
                    List<RequestUrlEntity> list = new ArrayList<RequestUrlEntity>();
                    if (!TextUtils.isEmpty((CharSequence)resourceList)) {
                        resourceList = resourceList.replace("resourceRegionalismCode", "regionalismCode");
                        list = JSON.parseArray((String)resourceList, RequestUrlEntity.class);
                    }
                    if ((execute = (call = RetrofitFactory.getInstance().getUrlConverterApi().queryResourceAddress(UrlConstant.getRsbSearchResourceUrl(), appCredential, messageId, version, list)).execute()).isSuccessful()) {
                        ServiceBusProvider.this.buildSuccessRet2Bundle(resultVersion, (Response<List<UrlEntity>>)execute, bundle);
                    } else {
                        String message = "\u670d\u52a1\u5668\u8bf7\u6c42\u5931\u8d25,\u8bf7\u68c0\u67e5\u7f51\u7edc\u6216\u8005sod\u670d\u52a1:" + UrlConstant.getRsbSearchResourceUrl();
                        int resultCode = 41003;
                        ServiceBusProvider.this.buildFailRet2Bundle(resultVersion, resultCode, message, messageId, bundle);
                    }
                }
                catch (Exception e) {
                    String message;
                    int resultCode;
                    e.printStackTrace();
                    if (e instanceof UnsupportedEncodingException) {
                        resultCode = 41002;
                        message = "\u5e94\u7528\u51ed\u8bc1 encode\u5931\u8d25:" + e.getMessage();
                    } else if (e instanceof NumberFormatException) {
                        resultCode = 41004;
                        message = "\u5bfb\u5740\u4f20\u5165\u7684version\u4e0d\u662f\u963f\u62c9\u4f2f\u6570\u5b57";
                    } else if (e instanceof NetworkOnMainThreadException) {
                        resultCode = 41001;
                        message = "\u4e3b\u7ebf\u7a0b\u8c03\u7528\u5bfb\u5740\uff0c\u6539\u4e3a\u5b50\u7ebf\u7a0b\u8c03\u7528";
                    } else if (e instanceof SocketTimeoutException || e instanceof ConnectException) {
                        resultCode = 41003;
                        message = "\u670d\u52a1\u5668\u8bf7\u6c42\u5931\u8d25,\u8bf7\u68c0\u67e5\u7f51\u7edc\u6216\u8005sod\u670d\u52a1:" + UrlConstant.getRsbSearchResourceUrl();
                    } else if (e instanceof EOFException) {
                        resultCode = 41005;
                        message = "\u8bf7\u6c42\u5bfb\u5740\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5e94\u7528\u51ed\u8bc1\u662f\u5426\u89c4\u8303\uff0c\u9519\u8bef\u4fe1\u606f:" + e;
                    } else {
                        resultCode = 41000;
                        message = "\u8bf7\u6c42\u5931\u8d25:" + (TextUtils.isEmpty((CharSequence)e.getMessage()) ? e : e.getMessage());
                    }
                    ServiceBusProvider.this.buildFailRet2Bundle(resultVersion, resultCode, message, messageId, bundle);
                }
                finally {
                    downLatch.countDown();
                }
            }
        });
        executorService.shutdown();
        try {
            downLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return bundle;
    }

    private void buildFailRet2Bundle(int version, int resultCode, String message, String messageId, Bundle ret) {
        ret.putInt(VERSION, version);
        ret.putInt("resultCode", resultCode);
        ret.putString("message", message);
        ret.putString(MESSAGE_ID, messageId);
        ret.putString("resourceList", null);
    }

    private void buildSuccessRet2Bundle(int version, Response<List<UrlEntity>> response, Bundle ret) {
        Headers headers = response.headers();
        String code = headers.get("code");
        String resultMessageId = headers.get(MESSAGE_ID);
        String message = headers.get("message");
        ret.putInt(VERSION, version);
        ret.putInt("resultCode", Integer.parseInt(code));
        ret.putString(MESSAGE_ID, resultMessageId);
        ret.putString("message", message);
        if ("0".equals(code)) {
            List body = (List)response.body();
            if (body != null) {
                String json = JSON.toJSONString((Object)body);
                String result = json.replace("regionalismCode", "resourceRegionalismCode");
                ret.putString("resourceList", result);
            } else {
                ret.putString("resourceList", null);
            }
        } else {
            ret.putString("resourceList", null);
        }
    }

    static {
        mUriMatcher.addURI(AUTHORITY, null, 0);
    }
}

