/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.spider.admin.service.impl;

import com.xdja.spider.admin.dao.IPublisherDao;
import com.xdja.spider.admin.service.IPublisherService;
import com.xdja.spider.core.bean.Publisher;
import com.xdja.spider.core.util.EncryptUtil;
import com.xdja.spider.core.util.StringUtil;
import com.xdja.spider.core.util.UUIDUtil;
import java.util.List;
import org.jfaster.mango.plugin.page.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PublisherServiceImpl
implements IPublisherService {
    @Autowired
    private IPublisherDao publisherDao;

    public long save(Publisher publisher) {
        publisher.setSn(UUIDUtil.random());
        publisher.setPassword(EncryptUtil.encodeSHA1((String)"111111"));
        return this.publisherDao.save(publisher);
    }

    public void save(List<Publisher> publishers) {
        for (Publisher publisher : publishers) {
            publisher.setSn(UUIDUtil.random());
            publisher.setPassword(EncryptUtil.encodeSHA1((String)"111111"));
        }
        this.publisherDao.save(publishers);
    }

    public void update(Publisher publisher) {
        publisher.setUpdateTime(Long.valueOf(System.currentTimeMillis()));
        this.publisherDao.update(publisher);
    }

    public Publisher get(Long id) {
        return this.publisherDao.get(id);
    }

    public Publisher get(String account, String password) {
        return this.publisherDao.get(account, password);
    }

    public Publisher get(String account) {
        return this.publisherDao.get(account);
    }

    public List<Publisher> list() {
        return this.publisherDao.list();
    }

    public List<Publisher> list(String searchKey, Page page) {
        if (!"".equals(searchKey = StringUtil.null2Blank((String)searchKey))) {
            searchKey = "%" + searchKey + "%";
        }
        return this.publisherDao.list(searchKey, page);
    }

    public void del(Long id) {
        this.publisherDao.del(id);
    }

    public void restPassword(long publisherId) {
        this.publisherDao.updatePassword(publisherId, EncryptUtil.encodeSHA1((String)"111111"));
    }

    public void changeStatus(long publisherId, int status) {
        this.publisherDao.changeStatus(publisherId, status);
    }
}

