/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.spider.admin.service.impl;

import com.xdja.spider.admin.dao.IColumnDao;
import com.xdja.spider.admin.service.IColumnService;
import com.xdja.spider.core.bean.Column;
import com.xdja.spider.core.util.StringUtil;
import com.xdja.spider.core.util.UUIDUtil;
import java.util.List;
import org.jfaster.mango.plugin.page.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ColumnServiceImpl
implements IColumnService {
    @Autowired
    private IColumnDao columnDao;

    public long save(Column column) {
        column.setSn(UUIDUtil.random());
        return this.columnDao.save(column);
    }

    public void save(List<Column> columns) {
        for (Column column : columns) {
            column.setSn(UUIDUtil.random());
        }
        this.columnDao.save(columns);
    }

    public void update(Column column) {
        this.columnDao.update(column);
    }

    public Column get(Long id) {
        return this.columnDao.get(id);
    }

    public List<Column> list() {
        return this.columnDao.list();
    }

    public List<Column> list(long publisherId) {
        return this.columnDao.list(publisherId);
    }

    public List<Column> list(long publisherId, int type) {
        return this.columnDao.list(publisherId, type);
    }

    public List<Column> list(Long publisherId, String searchKey, Page page) {
        if (!"".equals(searchKey = StringUtil.null2Blank((String)searchKey))) {
            searchKey = "%" + searchKey + "%";
        }
        return this.columnDao.list(publisherId, searchKey, page);
    }

    public List<Column> grabList() {
        return this.columnDao.grabList(Column.Status.ENABLE.value, Column.Type.MANUAL.value);
    }

    public void del(Long id) {
        this.columnDao.del(id);
    }

    public void changeStatus(long columnId, int status) {
        this.columnDao.changeStatus(columnId, status);
    }

    public void changeAccss(Long id, int value) {
        this.columnDao.chngeAccess(id, value);
    }
}

