/**
 * Created by publisher on 2017/8/18.
 * 文章管理js
 */
$(".layui-nav-item").not($(".layui-nav-item.nav-article")).removeClass("layui-this");
$(".layui-nav-item.nav-article").addClass("layui-this");
var form, layedit, uploadUrl;
layui.use('layer', function () {
  layer = layui.layer;
  layer.closeAll('page');
});
var E = window.wangEditor;
var addArticleEditor,editArticleEditor;

var dataObj = {
  search: {
    //查询条件
    condition: {
      searchKey: "",
      colId: null
    },
    total: 0,
    //查询结果
    data: []
  },
  editItem: {},
  colList: [],//我的栏目
  colObj: {
    //1:栏目1
  }
};

//点击检索/分页
function searchData(pageNo, isClickSearch) {
  var pageSize = 10;
  var postData = {
    pageSize: pageSize,
    pageNum: pageNo,
    searchKey: dataObj.search.condition.searchKey,
    colId: dataObj.search.condition.colId
  };
  $.ajax({
    type: 'POST',
    url: "publisher/article/list",
    data: JSON.stringify(postData),
    success: function (res) {
      layer.closeAll('loading');
      if (res.flag) {
        //查询成功
        dataObj.search.data = res.data.list;
        //渲染搜索结果数目
        $("#searchCount").html("共得到记录：" + res.data.total);
        //渲染列表
        if (typeof dataObj.search.data === "object" && dataObj.search.data instanceof Array) {
          renderSearchResult();
        }
        if (isClickSearch) {
          //点击了查询或者是刚进入页面
          //渲染分页
          var pageTotal = res.data.total % pageSize > 0 ? parseInt(res.data.total / pageSize) + 1 : res.data.total / pageSize;
          initPage(pageTotal);
        }
      } else {
        layer.alert(res.data.errorCode || res.data);
      }
    }

  });
}

//使用layui模板引擎
function renderSearchResult() {
  layui.use('laytpl', function () {
    var laytpl = layui.laytpl;
    //渲染查询结果
    var searchTpl = searchModule.innerHTML;
    laytpl(searchTpl).render(dataObj, function (html) {
      searchDataView.innerHTML = html;
    });
  });

}

//使用layui分页组件
function initPage(pageTotal) {
  layui.use(['laypage', 'layer'], function () {
    var laypage = layui.laypage;
    laypage({
      cont: 'pager',
      pages: pageTotal,//总页数
      groups: 5,//连续显示分页数目
      skip: true,
      jump: function (obj, first) {
        if (!first) {
          searchData(obj.curr, false);
        }
      }
    });
  });
}


function searchForm() {
  dataObj.search.condition.searchKey = $("#searchKey").val();
  dataObj.search.condition.colId = $("#colId").val() == 0 ? null : $("#colId").val();
  searchData(1, true);
}


//点击查询
$("#searchBtn").click(function () {
  searchForm();
});

//定义新增APP校验规则
var addValidator = $("#addArticleForm").validate({
  rules: {
    articleTitle: {required: true, notEmpty: true},
    articleDate: {required: true},
    description: {required: true, notEmpty: true}
  },
  messages: {
    articleTitle: {
      required: "请输入标题",
      notEmpty: "请输入标题"
    },
    articleDate: {
      required: "请选择日期"
    },
    description: {
      required: "请输入描述",
      notEmpty: "请输入描述"
    }
  },
  /*错误提示位置*/
  errorPlacement: function (error, element) {
    element.parent().addClass("error-item");
    element.after(error);
  },
  success: function (tip) {
    $(tip).parent().removeClass("error-item");
    $(tip).remove();
  },
  submitHandler: function () {
    var content = addArticleEditor.txt.html();
    if(addArticleEditor.txt.text().length <=  0){
      $("#addArticleEditor").after('<label id="addArticleEditor-error" class="error">请输入内容</label>');
    }else{
      $("#addArticleEditor-error").remove();
    }
    var postData = {
      columnId: $("#articleColId").val(),
      title: $("#articleTitle").val(),
      date: $("#articleDate").val(),
      description: $("#description").val(),
      releaseStatus: addArticleForm.releaseStatus.value,
      content: content
    };
    $.ajax({
      type: 'POST',
      url: "publisher/article/save",
      data: JSON.stringify(postData),
      success: function (res) {
        if (res.flag) {
          layer.closeAll('page');
          searchForm();
          layer.msg('添加文章成功');
        } else {
          layer.alert(res.data.errorCode || res.data);
        }
      }
    });
  }
});

//点击新建显示新建界面
$("#addBtn").click(function () {
  $("#articleColId").val(dataObj.colList[0].id);
  $("#articleTitle").val("");
  $("#articleDate").val("");
  addArticleForm.releaseStatus.value = 2;
  $("#description").val("");
  $("#articleContent").val("");

  form.render('radio');
  form.render('select');
  //判断是否生成过编辑器
  if (addArticleEditor) {
    addArticleEditor.txt.clear();
  } else {
    addArticleEditor = new E('#addArticleEditor');
    addArticleEditor.customConfig.menus = [
      'head',  // 标题
      'bold',  // 粗体
      'italic',  // 斜体
      'underline',  // 下划线
      'strikeThrough',  // 删除线
      'foreColor',  // 文字颜色
      'backColor',  // 背景颜色
      'link',  // 插入链接
      'justify',  // 对齐方式
      'image'  // 插入图片
    ];
    addArticleEditor.customConfig.uploadImgServer = uploadUrl;
    addArticleEditor.customConfig.uploadImgParams = {
      perm: 1
    };
    addArticleEditor.customConfig.uploadImgHooks = {
      // 如果服务器端返回的不是 {errno:0, data: [...]} 这种格式，可使用该配置
      customInsert: function (insertImg, result, editor) {
        // 图片上传并返回结果，自定义插入图片的事件（而不是编辑器自动插入图片！！！）
        // insertImg 是插入图片的函数，editor 是编辑器对象，result 是服务器端返回的结果
        var url = localImg + result[0].fileid;
        insertImg(url);
      }
    };
    addArticleEditor.create();
  }

  layui.use('laydate', function () {
    laydate = layui.laydate;
    document.getElementById('articleDate').onclick = function () {
      laydate({
        elem: this,
        min: '1900-01-01 00:00:00'
        , max: laydate.now()
        , istoday: false
        , choose: function (datas) {
        }
      });

    };
  });

  $("#addArticleForm input").removeClass("error");
  $("#addArticleForm label.error").remove();
  $("#addArticleForm .layui-form-item").removeClass("error-item");
  layer.open({
    type: 1,
    title: "添加文章",
    content: $('#addArticle'),
    btn: [],
    area: ['800px', '600px']
  })
});

//定义编辑校验规则
var editValidator = $("#editArticleForm").validate({
  rules: {
    editArticleTitle: {required: true, notEmpty: true},
    editArticleDate: {required: true},
    editDescription: {required: true, notEmpty: true}
  },
  messages: {
    editArticleTitle: {
      required: "请输入标题",
      notEmpty: "请输入标题"
    },
    editArticleDate: {
      required: "请选择日期"
    },
    editDescription: {
      required: "请输入描述",
      notEmpty: "请输入描述"
    }
  },
  /*错误提示位置*/
  errorPlacement: function (error, element) {
    element.parent().addClass("error-item");
    element.after(error);
  },
  success: function (tip) {
    $(tip).parent().removeClass("error-item");
    $(tip).remove();
  },
  submitHandler: function () {
    var content = editArticleEditor.txt.html();
    if(editArticleEditor.txt.text().length <=  0){
      $("#editArticleEditor").after('<label id="editArticleEditor-error" class="error" for="editArticleEditor">请输入内容</label>');
    }else{
      $("#editArticleEditor-error").remove();
    }
    var postData = {
      id: dataObj.editItem.id,
      columnId: $("#editArticleColId").val(),
      title: $("#editArticleTitle").val(),
      date: $("#editArticleDate").val(),
      description: $("#editDescription").val(),
      releaseStatus: editArticleForm.editReleaseStatus.value,
      content: content
    };
    $.ajax({
      type: 'POST',
      url: "publisher/article/update",
      data: JSON.stringify(postData),
      success: function (res) {
        if (res.flag) {
          layer.closeAll('page');
          searchForm();
          layer.msg('修改文章成功');
        } else {
          layer.alert(res.data.errorCode || res.data);
        }
      }
    });
  }
});


//点击编辑界面显示编辑界面
function editItem(index) {
  dataObj.editItem = dataObj.search.data[index];
  editValidator.resetForm();
  $("#editArticleColId").val(dataObj.editItem.columnId);
  form.render('select');
  $("#editArticleTitle").val(dataObj.editItem.title);

  $("#editArticleDate").val(dataObj.editItem.date);
  layui.use('laydate', function () {
    laydate = layui.laydate;
    document.getElementById('editArticleDate').onclick = function () {
      laydate({
        elem: this,
        min: '1900-01-01 00:00:00'
        , max: laydate.now()
        , istoday: false
        , choose: function (datas) {
        }
      });

    };
  });

  $("#editDescription").val(dataObj.editItem.description);

  editArticleForm.editReleaseStatus.value = dataObj.editItem.releaseStatus;
  form.render('radio');

  //判断是否生成过编辑器
  if (!editArticleEditor) {
    editArticleEditor = new E('#editArticleEditor');
    editArticleEditor.customConfig.menus = [
      'head',  // 标题
      'bold',  // 粗体
      'italic',  // 斜体
      'underline',  // 下划线
      'strikeThrough',  // 删除线
      'foreColor',  // 文字颜色
      'backColor',  // 背景颜色
      'link',  // 插入链接
      'justify',  // 对齐方式
      'image'  // 插入图片
    ];
    editArticleEditor.customConfig.uploadImgServer = uploadUrl;
    editArticleEditor.customConfig.uploadImgParams = {
      perm: 1
    };
    editArticleEditor.customConfig.uploadImgHooks = {
      // 如果服务器端返回的不是 {errno:0, data: [...]} 这种格式，可使用该配置
      customInsert: function (insertImg, result, editor) {
        // 图片上传并返回结果，自定义插入图片的事件（而不是编辑器自动插入图片！！！）
        // insertImg 是插入图片的函数，editor 是编辑器对象，result 是服务器端返回的结果
        var url = localImg + result[0].fileid;
        insertImg(url);
      }
    };
    editArticleEditor.create();
  }
  editArticleEditor.txt.html(dataObj.editItem.content);

  $("#editArticleForm input").removeClass("error");
  $("#editArticleForm label.error").remove();
  $("#editArticleForm .layui-form-item").removeClass("error-item");
  layer.open({
    type: 1,
    title: dataObj.editItem.account,
    content: $('#editArticle'),
    area: ['800px', '600px']
  })
}

//点击删除
function delItem(index) {
  var delItem = dataObj.search.data[index];
  //点击确定回调
  layer.confirm('是否确认删除？', function (index) {
    $.ajax({
      type: 'GET',
      url: "publisher/article/del/" + delItem.id,
      success: function (res) {
        if (res.flag) {
          layer.msg('删除成功');
          searchForm();
        } else {
          layer.alert(res.data.errorCode || res.data);
        }
      }
    });
  });
}

//点击重新抓取
function reGrabItem(index) {
  var reGrabItem = dataObj.search.data[index];
  $.ajax({
    type: 'GET',
    url: "publisher/article/grab/again/" + reGrabItem.id,
    success: function (res) {
      if (res.flag) {
        layer.msg('重新抓取成功');
      } else {
        layer.alert(res.data.errorCode || res.data);
      }
    }
  });
}

//点击发布
function releaseItem(index) {
    $.ajax({
        type: 'POST',
        url: "publisher/article/release/" + dataObj.search.data[index].id,
        success: function (res) {
            if (res.flag) {
                searchForm();
                layer.msg('发布成功');
            } else {
                layer.alert(res.data.errorCode || res.data);
            }
        }
    });
}

//点击关闭
function closeItem(index) {
    var disabledItem = dataObj.search.data[index];
    layer.confirm('"' + disabledItem.name + '"是否确定关闭？', function (index) {
        //点击确定回调
        $.ajax({
            type: 'POST',
            url: "publisher/article/close/" + disabledItem.id,
            success: function (res) {
                if (res.flag) {
                    searchForm();
                    layer.msg('关闭成功');
                } else {
                    layer.alert(res.data.errorCode || res.data);
                }
            }
        });
    });
}

//进入页面执行查询
var uploadUrl = "", localImg = "http://11.12.108.205/";
layui.use('layer', function () {
  layer = layui.layer;
  setTimeout(function () {
    //请求我的栏目
    // $.ajax({
    //   type: 'GET',
    //   url: "publisher/column/myList",
    //   success: function (res) {
    //     if (res.flag) {
    //       $("#articleColId").empty();
    //       $.each(res.data, function (index, val, arr) {
    //         $("#colId").append("<option value='" + val.id + "'>" + val.name + "</option>");
    //         $("#articleColId").append("<option value='" + val.id + "'>" + val.name + "</option>");
    //         $("#editArticleColId").append("<option value='" + val.id + "'>" + val.name + "</option>");
    //         dataObj.colObj[val.id] = val.name;
    //       });
    //       dataObj.colList = res.data;
    //       layui.use('form', function () {
    //         form = layui.form();
    //         form.render('select');
    //       });
    //
    //       //请求文章列表
    //       searchForm();
    //     } else {
    //       layer.alert(res.data.errorCode || res.data);
    //     }
    //   }
    // });

      $.ajax({
          type: 'GET',
          url: "publisher/column/myManualList",
          success: function (res) {
              if (res.flag) {
                  $("#articleColId").empty();
                  $.each(res.data, function (index, val, arr) {
                      $("#colId").append("<option value='" + val.id + "'>" + val.name + "</option>");
                      $("#articleColId").append("<option value='" + val.id + "'>" + val.name + "</option>");
                      $("#editArticleColId").append("<option value='" + val.id + "'>" + val.name + "</option>");
                      dataObj.colObj[val.id] = val.name;
                  });
                  dataObj.colList = res.data;
                  layui.use('form', function () {
                      form = layui.form();
                      form.render('select');
                  });

                  //请求文章列表
                  searchForm();
              } else {
                  layer.alert(res.data.errorCode || res.data);
              }
          }
      });

    //请求文件上传地址
    $.ajax({
      type: 'GET',
      url: "sys/getUploadUrl",
      success: function (res) {
        if (res.flag) {
          uploadUrl = res.data;
          localImg = 'http://' + uploadUrl.split("/")[2] + "/";
        } else {
          layer.alert(res.data.errorCode || res.data);
        }
      }
    });
  }, 1);
});


