/**
 * Created by admin on 2017/8/15.
 * 栏目管理js
 */

$(".layui-nav-item").not($(".layui-nav-item.nav-column")).removeClass("layui-this");
$(".layui-nav-item.nav-column").addClass("layui-this");


var form;
layui.use(['layer', 'form'], function () {
  layer = layui.layer;
  layer.closeAll('page');
  form = layui.form();
});
var dataObj = {
  search: {
    //查询条件
    condition: {
      searchKey: ""
    },
    total: 0,
    //查询结果
    data: []
  },
  editItem: {}
};

//点击检索/分页
function searchData(pageNo, isClickSearch) {
  var pageSize = 10;
  var postData = {
    pageSize: pageSize,
    pageNum: pageNo,
    searchKey: dataObj.search.condition.searchKey
  };
  $.ajax({
    type: 'POST',
    url: "publisher/column/list",
    data: JSON.stringify(postData),
    success: function (res) {
      layer.closeAll('loading');
      if (res.flag) {
        //查询成功
        dataObj.search.data = res.data.list;
        //渲染搜索结果数目
        $("#searchCount").html("共得到记录：" + res.data.total);

        //渲染列表
        if (typeof dataObj.search.data === "object" && dataObj.search.data instanceof Array) {
          renderSearchResult();
        }
        if (isClickSearch) {
          //点击了查询或者是刚进入页面
          //渲染分页
          var pageTotal = res.data.total % pageSize > 0 ? parseInt(res.data.total / pageSize) + 1 : res.data.total / pageSize;
          initPage(pageTotal);
        }
      } else {
        layer.alert(res.data.errorCode || res.data);
      }
    }

  });
}

//使用layui模板引擎
function renderSearchResult() {
  layui.use('laytpl', function () {
    var laytpl = layui.laytpl;
    //渲染查询结果
    var searchTpl = searchModule.innerHTML;
    laytpl(searchTpl).render(dataObj, function (html) {
      searchDataView.innerHTML = html;
    });
  });

}

//使用layui分页组件
function initPage(pageTotal) {
  layui.use(['laypage', 'layer'], function () {
    var laypage = layui.laypage;
    laypage({
      cont: 'pager',
      pages: pageTotal,//总页数
      groups: 5,//连续显示分页数目
      skip: true,
      jump: function (obj, first) {
        if (!first) {
          searchData(obj.curr, false);
        }
      }
    });
  });
}

function searchForm() {
  dataObj.search.condition.searchKey = $("#searchKey").val();
  searchData(1, true);
}

//点击查询
$("#searchBtn").click(function () {
  searchForm();
});

//校验名称
function validName(id) {
  var validName = false;
  if ($("#" + id).val().trim().length <= 0) {
    $("#" + id).parent().addClass("error-item");
    $("#" + id).addClass("error");
    if ($("#" + id + "-error").length > 0) {
      $("#" + id + "-error").html("请输入名称")
    } else {
      $("#" + id).after('<label id="' + id + '-error" class="error" for="' + id + '">请输入名称</label>');
    }
  } else {
    $("#" + id).parent().removeClass("error-item");
    $("#" + id).removeClass("error");
    $("#" + id + "-error").remove();
    validName = true;
  }
  return validName;
}
//校验排序
function validSeq(id) {
  var validSeq = false;
  if ($("#" + id).val().trim().length <= 0) {
    $("#" + id).parent().addClass("error-item");
    $("#" + id).addClass("error");
    if ($("#" + id + "-error").length > 0) {
      $("#" + id + "-error").html("请输入排序")
    } else {
      $("#" + id).after('<label id="' + id + '-error" class="error" for="' + id + '">请输入排序</label>');
    }
  } else if (isNaN($("#" + id).val())) {
    $("#" + id).parent().addClass("error-item");
    $("#" + id).addClass("error");
    if ($("#" + id + "-error").length > 0) {
      $("#" + id + "-error").html("排序为正整数")
    } else {
      $("#" + id).after('<label id="' + id + '-error" class="error" for="' + id + '">排序为正整数</label>');
    }
  } else if ($("#" + id).val() % 1 != 0) {
    $("#" + id).parent().addClass("error-item");
    $("#" + id).addClass("error");
    if ($("#" + id + "-error").length > 0) {
      $("#" + id + "-error").html("排序为正整数")
    } else {
      $("#" + id).after('<label id="' + id + '-error" class="error" for="' + id + '">排序为正整数</label>');
    }
  } else {
    $("#" + id).parent().removeClass("error-item");
    $("#" + id).removeClass("error");
    $("#" + id + "-error").remove();
    validSeq = true;
  }
  return validSeq;
}


//点击新建显示新建界面
$("#addBtn").click(function () {
  $("#columnName").val("");
  //$("#icon").val("");
  $("#columnType").val("1");
  form.render('select');
  form.render('radio');
  $("#columnSeq").val("");
  $("#columnInfo").val("");
  $("#addColumnForm input").removeClass("error");
  $("#addColumnForm label.error").remove();
  $("#addColumnForm .layui-form-item").removeClass("error-item");
  layer.open({
    type: 1,
    title: "添加栏目",
    content: $('#addColumn'),
    btn: [],
    area: '450px'
  })
});


//点击编辑界面显示编辑界面
function editItem(index) {
  dataObj.editItem = dataObj.search.data[index];
  $("#editColumnName").val(dataObj.editItem.name);
  $("#editColumnType").val(dataObj.editItem.type);
  form.render('select');
  editColumnForm.editIsPublic.value = dataObj.editItem.isPublic;
  editColumnForm.editColumnStatus.value = dataObj.editItem.status;
  form.render('radio');
  $("#editColumnSeq").val(dataObj.editItem.seq);
  $("#editColumnInfo").val(dataObj.editItem.info);
  $("#editIcon").val(dataObj.editItem.icon);
  if(dataObj.editItem.icon){
    $("#editLogoImg").attr("src",localImg + dataObj.editItem.icon);
  }else{
    $("#editLogoImg").attr("src","img/fileAdd.jpg")
  }
  $("#editColumnForm input").removeClass("error");
  $("#editColumnForm label.error").remove();
  $("#editColumnForm .layui-form-item").removeClass("error-item");
  layer.open({
    type: 1,
    title: dataObj.editItem.name,
    content: $('#editColumn'),
    area: '450px'
  })
}

//定义栏目配置校验规则
var addValidator = $("#grabSetForm").validate({
  rules: {
    webName: {required: true, notEmpty: true},
    webDomain: {required: true, notEmpty: true},
    sourceUrl: {required: true, notEmpty: true},
    listSelect: {required: true, notEmpty: true},
    urlSelect: {required: true, notEmpty: true},
    titleSelect: {required: true, notEmpty: true}
  },
  messages: {
    webName: {
      required: "请输入网站名称",
      notEmpty: "请输入网站名称"
    },
    webDomain: {
      required: "请输入网站域名",
      notEmpty: "请输入网站域名"
    },
    sourceUrl: {
      required: "请输入抓取地址",
      notEmpty: "请输入抓取地址"
    },
    listSelect: {
      required: "请输入列表定位",
      notEmpty: "请输入列表定位"
    },
    urlSelect: {
      required: "请输入详情URL定位",
      notEmpty: "请输入详情URL定位"
    },
    titleSelect: {
      required: "请输入标题定位",
      notEmpty: "请输入标题定位"
    }
  },
  /*错误提示位置*/
  errorPlacement: function (error, element) {
    element.parent().addClass("error-item");
    element.after(error);
  },
  success: function (tip) {
    $(tip).parent().removeClass("error-item");
    $(tip).remove();
  },
  submitHandler: function () {
    var postData = {
      id: dataObj.editGrabSetItem.id ? dataObj.editGrabSetItem.id : "",
      columnId: dataObj.grabSetItem.id,
      webName: $("#webName").val(),
      webDomain: $("#webDomain").val(),
      sourceUrl: $("#sourceUrl").val(),
      listSelect: $("#listSelect").val(),
      dateSelect: $("#dateSelect").val(),

      urlSelect: $("#urlSelect").val(),
      nextPageSelect: $("#nextPageSelect").val(),
      nextPageParams: $("#nextPageParams").val(),
      titleSelect: $("#titleSelect").val(),
      contentSelect: $("#contentSelect").val()
    };
    $.ajax({
      type: 'POST',
      url: "publisher/column/grabconf/save",
      data: JSON.stringify(postData),
      success: function (res) {
        if (res.flag) {
          layer.closeAll('page');
          layer.msg('保存栏目配置成功');
        } else {
          layer.alert(res.data.errorCode || res.data);
        }
      }
    });
  }
});


//点击栏目抓取配置
function grabSetItem(index) {
  dataObj.grabSetItem = dataObj.search.data[index];
  $.ajax({
    type: 'GET',
    url: "publisher/column/grabconf/get/" + dataObj.grabSetItem.id,
    success: function (res) {
      if (res.flag) {
        addValidator.resetForm();
        $("#grabSetForm input").removeClass("error");
        $("#grabSetForm label.error").remove();
        $("#grabSetForm .layui-form-item").removeClass("error-item");
        if (res.data) {
          dataObj.editGrabSetItem = res.data;
          $("#webName").val(dataObj.editGrabSetItem.webName);
          $("#webDomain").val(dataObj.editGrabSetItem.webDomain);
          $("#sourceUrl").val(dataObj.editGrabSetItem.sourceUrl);
          $("#listSelect").val(dataObj.editGrabSetItem.listSelect);
          $("#dateSelect").val(dataObj.editGrabSetItem.dateSelect);
          $("#urlSelect").val(dataObj.editGrabSetItem.urlSelect);
          $("#nextPageSelect").val(dataObj.editGrabSetItem.nextPageSelect);
          $("#nextPageParams").val(dataObj.editGrabSetItem.nextPageParams);
          $("#titleSelect").val(dataObj.editGrabSetItem.titleSelect);
          $("#contentSelect").val(dataObj.editGrabSetItem.contentSelect);
        }else{
          dataObj.editGrabSetItem = "";
          $("#webName").val("");
          $("#webDomain").val("");
          $("#sourceUrl").val("");
          $("#listSelect").val("");
          $("#dateSelect").val("");
          $("#urlSelect").val("");
          $("#nextPageSelect").val("");
          $("#nextPageParams").val("");
          $("#titleSelect").val("");
          $("#contentSelect").val("");
        }

        layer.open({
          type: 1,
          title: dataObj.grabSetItem.name + '-抓取配置',
          content: $('#grabSet'),
          area: ['650px', '550px']
        });
      } else {
        layer.alert(res.data.errorCode || res.data);
      }
    }
  });

}


//点击启用
function enableItem(index) {
  $.ajax({
    type: 'GET',
    url: "publisher/column/enable/" + dataObj.search.data[index].id,
    success: function (res) {
      if (res.flag) {
        searchForm();
        layer.msg('启用成功');
      } else {
        layer.alert(res.data.errorCode || res.data);
      }
    }
  });
}

//点击停用
function disabledItem(index) {
  var disabledItem = dataObj.search.data[index];
  layer.confirm('"' + disabledItem.name + '"是否确定停用？', function (index) {
    //点击确定回调
    $.ajax({
      type: 'GET',
      url: "publisher/column/disable/" + disabledItem.id,
      success: function (res) {
        if (res.flag) {
          searchForm();
          layer.msg('停用成功');
        } else {
          layer.alert(res.data.errorCode || res.data);
        }
      }
    });
  });
}

//点击栏目私有
function privateItem(index) {
  var privateItem = dataObj.search.data[index];
  layer.confirm('"' + privateItem.name + '"是否确定私有？', function (index) {
    $.ajax({
      type: 'GET',
      url: "publisher/column/private/" + privateItem.id,
      success: function (res) {
        if (res.flag) {
          searchForm();
          layer.msg('栏目私有成功');
        } else {
          layer.alert(res.data.errorCode || res.data);
        }
      }
    });
  });
}

//点击栏目公开
function publishItem(index) {
  var publishItem = dataObj.search.data[index];
  $.ajax({
    type: 'GET',
    url: "publisher/column/public/" + publishItem.id,
    success: function (res) {
      if (res.flag) {
        searchForm();
        layer.msg('栏目公开成功');
      } else {
        layer.alert(res.data.errorCode || res.data);
      }
    }
  });
}

//点击重抓数据
function regraspDataItem(index) {
  var regraspDataItem = dataObj.search.data[index];
  $.ajax({
    type: 'GET',
    url: "publisher/column/grab/" + regraspDataItem.id + "/again",
    success: function (res) {
      if (res.flag) {
        layer.msg('重抓数据成功');
      } else {
        layer.alert(res.data.errorCode || res.data);
      }
    }
  });
}

//点击重抓详情
function regraspInfoItem(index) {
  var regraspInfoItem = dataObj.search.data[index];
  $.ajax({
    type: 'GET',
    url: "publisher/column/grab/" + regraspInfoItem.id + "/detail/again",
    success: function (res) {
      if (res.flag) {
        layer.msg('重抓详情成功');
      } else {
        layer.alert(res.data.errorCode || res.data);
      }
    }
  });
}

//点击重新静态化
function reInitHtmlItem(index) {
  var reInitHtmlItem = dataObj.search.data[index];
  $.ajax({
    type: 'GET',
    url: "publisher/column/static/" + reInitHtmlItem.id + "/again",
    success: function (res) {
      if (res.flag) {
        layer.msg('重新静态化成功');
      } else {
        layer.alert(res.data.errorCode || res.data);
      }
    }
  });
}


//定义特殊抓取脚本校验规则
$("#specialGrabForm").validate({
  rules: {
    script: {required: true, notEmpty: true}
  },
  messages: {
    script: {
      required: "请输入python脚本",
      notEmpty: "请输入python脚本"
    }
  },
  /*错误提示位置*/
  errorPlacement: function (error, element) {
    element.parent().addClass("error-item");
    element.after(error);
  },
  success: function (tip) {
    $(tip).parent().removeClass("error-item");
    $(tip).remove();
  },
  submitHandler: function () {
    var postData = {
      id: dataObj.editGrabScriptItem.id ? dataObj.editGrabScriptItem.id : "",
      columnId: dataObj.specialGrabItem.id,
      script: $("#script").val()
    };
    $.ajax({
      type: 'POST',
      url: "publisher/column/grabscript/save",
      data: JSON.stringify(postData),
      success: function (res) {
        if (res.flag) {
          layer.closeAll('page');
          layer.msg('保存特殊抓取脚本成功');
        } else {
          layer.alert(res.data.errorCode || res.data);
        }
      }
    });
  }
});


//点击特殊抓取脚本
function specialGrabItem(index) {
  dataObj.specialGrabItem = dataObj.search.data[index];
  $.ajax({
    type: 'GET',
    url: "publisher/column/grabscript/get/" + dataObj.specialGrabItem.id,
    success: function (res) {
      if (res.flag) {
        $("#specialGrabForm input").removeClass("error");
        $("#specialGrabForm label.error").remove();
        $("#specialGrabForm .layui-form-item").removeClass("error-item");
        if (res.data) {
          dataObj.editGrabScriptItem = res.data;
          $("#script").val(dataObj.editGrabScriptItem.script);
        }else{
          dataObj.editGrabScriptItem = "";
          $("#script").val("");
        }

        layer.open({
          type: 1,
          title: dataObj.specialGrabItem.name + '-特殊抓取脚本',
          content: $('#specialGrab'),
          area: '600px'
        });
      } else {
        layer.alert(res.data.errorCode || res.data);
      }
    }
  });
}

//点击手动触发栏目抓取
function handGrabItem(index) {
  var handGrabItem = dataObj.search.data[index];
  $.ajax({
    type: 'GET',
    url: "publisher/column/grab/" + handGrabItem.id,
    success: function (res) {
      if (res.flag) {
        layer.msg('手动触发栏目抓取成功');
      } else {
        layer.alert(res.data.errorCode || res.data);
      }
    }
  });
}

//显示tip
function showTip(txt, id) {
  layer.tips(txt, '#' + id, {
    time: 0,
    tips: [1, '#0FA6D8'] //还可配置颜色
  });
}
function hideTip() {
  layer.closeAll('tips')
}
var uploadUrl="",localImg="http://11.12.108.205/";
//进入页面执行查询
layui.use('layer', function () {
  layer = layui.layer;
  setTimeout(function () {
    searchForm();

    //请求文件上传地址
    $.ajax({
      type: 'GET',
      url: "sys/getUploadUrl",
      success: function (res) {
        if (res.flag) {
          uploadUrl = res.data;
          localImg = 'http://'+ uploadUrl.split("/")[2] + "/";
          $('#addLogoInput').fileupload({
            type: "POST",
            dataType: 'json',
            url: uploadUrl,
            formData: {perm: 1},
            global: false,
            done: function (e, data) {
              $("#logoPath").val(data.result[0].fileid);
              $("#addLogoImg").attr("src",localImg + data.result[0].fileid);
            },
            fail:function(e,data){
              console.log("上传失败："+data.message);
            }
          });
          $('#editLogoInput').fileupload({
            type: "POST",
            dataType: 'json',
            url: uploadUrl,
            formData: {perm: 1},
            global: false,
            done: function (e, data) {
              $("#editIcon").val(data.result[0].fileid);
              $("#editLogoImg").attr("src",localImg + data.result[0].fileid);
            },
            fail:function(e,data){
              console.log("上传失败："+data.message);
            }
          });
        } else {
          layer.alert(res.data.errorCode || res.data);
        }
      }
    });
  }, 1);

});

