/**
 * Created by admin on 2017/8/15.
 * 发布者管理js
 */
$(".layui-nav-item").not($(".layui-nav-item.nav-publisher")).removeClass("layui-this");
$(".layui-nav-item.nav-publisher").addClass("layui-this");
var form;
layui.use('layer', function () {
  layer = layui.layer;
  layer.closeAll('page');
});

var dataObj = {
  search: {
    //查询条件
    condition: {
      searchKey: ""
    },
    total: 0,
    //查询结果
    data: []
  },
  editItem: {}
};

//点击检索/分页
function searchData(pageNo, isClickSearch) {
  var pageSize = 10;
  var postData = {
    pageSize: pageSize,
    pageNum: pageNo,
    searchKey: dataObj.search.condition.searchKey
  };
  $.ajax({
    type: 'POST',
    url: "admin/publisher/list",
    data: JSON.stringify(postData),
    success: function (res) {
      layer.closeAll('loading');
      if (res.flag) {
        //var res = JSON.parse(res);
        //查询成功
        dataObj.search.data = res.data.list;
        //渲染搜索结果数目
        $("#searchCount").html("共得到记录：" + res.data.total);
        //渲染列表
        if (typeof dataObj.search.data === "object" && dataObj.search.data instanceof Array) {
          renderSearchResult();
        }
        if (isClickSearch) {
          //点击了查询或者是刚进入页面
          //渲染分页
          var pageTotal = res.data.total % pageSize > 0 ? parseInt(res.data.total / pageSize) + 1 : res.data.total / pageSize;
          initPage(pageTotal);
        }
      } else {
        layer.alert(res.data.errorCode || res.data);
      }
    }
  });
}

//使用layui模板引擎
function renderSearchResult() {
  layui.use('laytpl', function () {
    var laytpl = layui.laytpl;
    //渲染查询结果
    var searchTpl = searchModule.innerHTML;
    laytpl(searchTpl).render(dataObj, function (html) {
      searchDataView.innerHTML = html;
    });
  });

}

//使用layui分页组件
function initPage(pageTotal) {
  layui.use(['laypage', 'layer'], function () {
    var laypage = layui.laypage;
    laypage({
      cont: 'pager',
      pages: pageTotal,//总页数
      groups: 5,//连续显示分页数目
      skip: true,
      jump: function (obj, first) {
        if (!first) {
          searchData(obj.curr, false);
        }
      }
    });
  });
}


function searchForm() {
  dataObj.search.condition.searchKey = $("#searchKey").val();
  searchData(1, true);
}


//点击查询
$("#searchBtn").click(function () {
  searchForm();
});

//定义新增APP校验规则
var addValidator = $("#addPublisherForm").validate({
  rules: {
    account: {required: true, notEmpty: true},
    name: {required: true, notEmpty: true},
  },
  messages: {
    account: {
      required: "请输入账号",
      notEmpty: "请输入账号"
    },
    name: {
      required: "请输入名称",
      notEmpty: "请输入名称"
    }
  },
  /*错误提示位置*/
  errorPlacement: function (error, element) {
    element.parent().addClass("error-item");
    element.after(error);
  },
  success: function (tip) {
    $(tip).parent().removeClass("error-item");
    $(tip).remove();
  },
  submitHandler: function () {
    var postData = {
      account: $("#account").val(),
      name: $("#name").val(),
      info: $("#info").val()
    };
    $.ajax({
      type: 'POST',
      url: "admin/publisher/save",
      data: JSON.stringify(postData),
      success: function (res) {
        if (res.flag) {
          layer.closeAll('page');
          searchForm();
          layer.msg('添加发布者成功');
        } else {
          layer.alert(res.data.errorCode || res.data);
        }
      }
    });
  }
});

//点击新建显示新建界面
$("#addBtn").click(function () {
  addValidator.resetForm();
  $("#account").val("");
  $("#name").val("");
  $("#info").val("");
  $("#addPublisherForm input").removeClass("error");
  $("#addPublisherForm label.error").remove();
  $("#addPublisherForm .layui-form-item").removeClass("error-item");
  layer.open({
    type: 1,
    title: "添加发布者",
    content: $('#addPublisher'),
    btn: [],
    area: '450px'
  })
});

//定义编辑校验规则
var editValidator = $("#editPublisherForm").validate({
  rules: {
    editAccount: {required: true, notEmpty: true},
    editName: {required: true, notEmpty: true}
  },
  messages: {
    editAccount: {
      required: "请输入账号",
      notEmpty: "请输入账号"
    },
    editName: {
      required: "请输入名称",
      notEmpty: "请输入名称"
    }
  },
  /*错误提示位置*/
  errorPlacement: function (error, element) {
    element.parent().addClass("error-item");
    element.after(error);
  },
  success: function (tip) {
    $(tip).parent().removeClass("error-item");
    $(tip).remove();
  },
  submitHandler: function () {
    var postData = {
      id: dataObj.editItem.id,
      name: $("#editName").val(),
      info: $("#editInfo").val()
    };
    $.ajax({
      type: 'POST',
      url: "admin/publisher/update",
      data: JSON.stringify(postData),
      success: function (res) {
        if (res.flag) {
          layer.closeAll('page');
          searchForm();
          layer.msg('修改成功');
        } else {
          layer.alert(res.data.errorCode || res.data);
        }
      }
    });
  }
});


//点击编辑界面显示编辑界面
function editItem(index) {
  dataObj.editItem = dataObj.search.data[index];
  editValidator.resetForm();
  $("#editAccount").val(dataObj.editItem.account);
  $("#editSn").val(dataObj.editItem.sn);
  $("#editName").val(dataObj.editItem.name);
  $("#editInfo").val(dataObj.editItem.info);
  $("#editPublisherForm input").removeClass("error");
  $("#editPublisherForm label.error").remove();
  $("#editPublisherForm .layui-form-item").removeClass("error-item");
  layer.open({
    type: 1,
    title: dataObj.editItem.account,
    content: $('#editPublisher'),
    area: '450px'
  })
}

//点击查看显示查看界面
function previewItem(index) {
  dataObj.viewItem = dataObj.search.data[index];
  $("#viewAccount").html(dataObj.viewItem.account);
  $("#viewName").html(dataObj.viewItem.name);
  $("#viewInfo").html(dataObj.viewItem.info);
  layer.open({
    type: 1,
    title: dataObj.viewItem.account,
    content: $('#viewPublisher'),
    area: '400px'
  })
}

//点击启用
function enableItem(index) {
  $.ajax({
    type: 'GET',
    url: "admin/publisher/enable/" + dataObj.search.data[index].id,
    success: function (res) {
      if (res.flag) {
        searchForm();
        layer.msg('启用成功');
      } else {
        layer.alert(res.data.errorCode || res.data);
      }
    }
  });
}

//点击停用
function disabledItem(index) {
  var disabledItem = dataObj.search.data[index];
  layer.confirm('"' + disabledItem.account + '"是否确认停用？', function (index) {
    //点击确定回调
    $.ajax({
      type: 'GET',
      url: "admin/publisher/disable/" + disabledItem.id,
      success: function (res) {
        if (res.flag) {
          searchForm();
          layer.msg('停用成功');
        } else {
          layer.alert(res.data.errorCode || res.data);
        }
      }
    });
  });
}

//点击重置
function resetItem(index) {
  var resetItem = dataObj.search.data[index];
  layer.confirm('"' + resetItem.account + '"的密码将被重置，是否确认？', function (index) {
    //点击确定回调
    $.ajax({
      type: 'GET',
      url: "admin/publisher/restPwd/" + resetItem.id,
      success: function (res) {
        if (res.flag) {
          layer.msg('重置密码成功');
        } else {
          layer.alert(res.data.errorCode || res.data);
        }
      }
    });
  });
}
//进入页面执行查询
layui.use('layer', function(){
  layer = layui.layer;
  setTimeout(function(){
    searchForm();
  },1);
});

