/**
 * Created by admin on 2017/8/18.
 * 系统配置js
 */
$(".layui-nav-item").not($(".layui-nav-item.nav-setting")).removeClass("layui-this");
$(".layui-nav-item.nav-setting").addClass("layui-this");
var form;
layui.use('layer', function () {
  layer = layui.layer;
  layer.closeAll('page');
});

var dataObj = {
  search: {
    total: 0,
    //查询结果
    data: []
  },
  editItem: {}
};

//点击检索/分页
function searchData() {
  $.ajax({
    type: 'GET',
    url: "admin/sysconf/list",
    success: function (res) {
      if (res.flag) {
        //var res = JSON.parse(res);
        //查询成功
        dataObj.search.data = res.data;
        //渲染搜索结果数目
        $("#searchCount").html("共得到记录：" + res.data.length);
        //渲染列表
        if (typeof dataObj.search.data === "object" && dataObj.search.data instanceof Array) {
          renderSearchResult();
        }
      } else {
        layer.alert(res.data.errorCode || res.data);
      }
    }

  });
}

//使用layui模板引擎
function renderSearchResult() {
  layui.use('laytpl', function () {
    var laytpl = layui.laytpl;
    //渲染查询结果
    var searchTpl = searchModule.innerHTML;
    laytpl(searchTpl).render(dataObj, function (html) {
      searchDataView.innerHTML = html;
    });
  });

}

//定义编辑校验规则
var editValidator = $("#systemSettingForm").validate({
  rules: {
    settingValue: {required: true, notEmpty: true}
  },
  messages: {
    settingValue: {
      required: "请输入值",
      notEmpty: "请输入值"
    }
  },
  /*错误提示位置*/
  errorPlacement: function (error, element) {
    element.parent().addClass("error-item");
    element.after(error);
  },
  success: function (tip) {
    $(tip).parent().removeClass("error-item");
    $(tip).remove();
  },
  submitHandler: function () {
    var postData = {
      id: dataObj.editItem.id,
      value: $("#settingValue").val()
    };
    $.ajax({
      type: 'POST',
      url: "admin/sysconf/update",
      data: JSON.stringify(postData),
      success: function (res) {
        if (res.flag) {
          layer.closeAll('loading');
          layer.closeAll('page');
          searchData();
          layer.msg('修改成功');
        } else {
          layer.alert(res.data.errorCode || res.data);
        }
      }
    });
  }
});

//点击编辑界面显示编辑界面
function editItem(index) {
  dataObj.editItem = dataObj.search.data[index];
  editValidator.resetForm();
  $("#settingKey").val(dataObj.editItem.key);
  $("#settingValue").val(dataObj.editItem.value);
  $("#settingLabel").val(dataObj.editItem.label);
  $("#settingRemark").val(dataObj.editItem.remark);
  $("#systemSettingForm input").removeClass("error");
  $("#systemSettingForm label.error").remove();
  $("#systemSettingForm .layui-form-item").removeClass("error-item");
  layer.open({
    type: 1,
    title: '修改系统配置',
    content: $('#systemSetting'),
    area: '450px'
  })
}

//进入页面执行查询
layui.use('layer', function(){
  layer = layui.layer;
  setTimeout(function(){
    searchData();
  },1);
});
