/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.spider.admin.control;

import com.xdja.spider.admin.bean.ListRequestBean;
import com.xdja.spider.admin.service.IPublisherService;
import com.xdja.spider.core.bean.Publisher;
import com.xdja.spider.core.page.Pagination;
import com.xdja.spider.core.util.IntUtil;
import com.xdja.spider.core.web.BaseControl;
import com.xdja.spider.core.web.BaseResponse;
import java.util.List;
import org.jfaster.mango.plugin.page.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/publisher/"})
public class PublisherControl
extends BaseControl {
    @Autowired
    private IPublisherService publisherService;

    @RequestMapping(value={"list"})
    public BaseResponse list(@RequestBody ListRequestBean requestBean) {
        this.logger.debug("\u83b7\u53d6\u53d1\u5e03\u8005\u5217\u8868");
        int pageNum = IntUtil.null2default((Integer)requestBean.getPageNum(), (int)1);
        int pageSize = IntUtil.null2default((Integer)requestBean.getPageSize(), (int)10);
        Page page = Page.create((int)pageNum, (int)pageSize);
        List list = this.publisherService.list(requestBean.getSearchKey(), page);
        return this.createSuccess(Pagination.create((int)pageNum, (int)pageSize, (int)page.getTotal(), (List)list));
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST})
    public BaseResponse save(@RequestBody Publisher publisher) {
        this.logger.debug("\u4fdd\u5b58\u53d1\u5e03\u8005");
        Publisher pub = this.publisherService.get(publisher.getAccount());
        if (null != pub) {
            return this.createFail("\u8d26\u6237\u5df2\u7ecf\u5b58\u5728");
        }
        long publisherId = this.publisherService.save(publisher);
        publisher.setId(Long.valueOf(publisherId));
        return this.createSuccess(publisher);
    }

    @RequestMapping(value={"update"}, method={RequestMethod.POST})
    public BaseResponse update(@RequestBody Publisher publisher) {
        this.logger.debug("\u4fee\u6539\u53d1\u5e03\u8005");
        this.publisherService.update(publisher);
        return this.createSuccess("success");
    }

    @RequestMapping(value={"get/{id}"}, method={RequestMethod.GET})
    public BaseResponse get(@PathVariable Long id) {
        Publisher publisher = this.publisherService.get(id);
        if (null == publisher) {
            return this.createFail("\u53d1\u5e03\u8005\u4e0d\u5b58\u5728");
        }
        return this.createSuccess(publisher);
    }

    @RequestMapping(value={"del/{id}"}, method={RequestMethod.GET})
    public BaseResponse del(@PathVariable Long id) {
        this.publisherService.del(id);
        return this.createSuccess("success");
    }

    @RequestMapping(value={"restPwd/{publisherId}"}, method={RequestMethod.GET})
    public BaseResponse restPassword(@PathVariable long publisherId) {
        this.logger.debug("\u91cd\u7f6e\u53d1\u5e03\u8005\u767b\u5f55\u5bc6\u7801");
        this.publisherService.restPassword(publisherId);
        return this.createSuccess("success");
    }

    @RequestMapping(value={"disable/{publisherId}"}, method={RequestMethod.GET})
    public BaseResponse disable(@PathVariable long publisherId) {
        this.publisherService.changeStatus(publisherId, Publisher.Status.DISABLE.value);
        return this.createSuccess("success");
    }

    @RequestMapping(value={"enable/{publisherId}"}, method={RequestMethod.GET})
    public BaseResponse enable(@PathVariable long publisherId) {
        this.publisherService.changeStatus(publisherId, Publisher.Status.ENABLE.value);
        return this.createSuccess("success");
    }
}

