/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.spider.admin.control;

import com.alibaba.fastjson.JSON;
import com.xdja.spider.admin.service.IPublisherService;
import com.xdja.spider.core.bean.Publisher;
import com.xdja.spider.core.util.EncryptUtil;
import com.xdja.spider.core.util.FastDFSUtil;
import com.xdja.spider.core.util.RedisUtil;
import com.xdja.spider.core.util.UUIDUtil;
import com.xdja.spider.core.web.BaseControl;
import com.xdja.spider.core.web.BaseResponse;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SysControl
extends BaseControl {
    @Autowired
    private IPublisherService publisherService;
    @Autowired
    private RedisUtil redisUtil;

    @RequestMapping(value={"/sys/login"}, method={RequestMethod.POST})
    public BaseResponse login(String account, String password) {
        final Publisher publisher = this.publisherService.get(account, EncryptUtil.encodeSHA1((String)password));
        if (null == publisher) {
            return this.createFail("\u8d26\u6237\u6216\u5bc6\u7801\u9519\u8bef");
        }
        if (publisher.getStatus() == Publisher.Status.DISABLE.value) {
            return this.createFail("\u8d26\u6237\u88ab\u505c\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        final String ticket = UUIDUtil.random();
        HashMap<String, Object> map = new HashMap<String, Object>(){
            private static final long serialVersionUID = -3027995260117310290L;
            {
                this.put("ticket", ticket);
                this.put("publisher", publisher);
            }
        };
        this.redisUtil.STRINGS.set("_spider-login-user_" + ticket, JSON.toJSONString((Object)publisher), 30);
        return this.createSuccess(map);
    }

    @RequestMapping(value={"/sys/logout"}, method={RequestMethod.GET})
    public BaseResponse logout(HttpServletRequest request) {
        String ticket = request.getHeader("Authorization");
        this.redisUtil.delete("_spider-login-user_" + ticket);
        return this.createSuccess("success");
    }

    @RequestMapping(value={"/sys/getUploadUrl"}, method={RequestMethod.GET})
    public BaseResponse getUploadUrl() {
        return this.createSuccess(FastDFSUtil.getUploadUrl((int)30));
    }
}

