/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.spider.admin.task;

import com.xdja.sc.client.core.MQSetting;
import com.xdja.sc.client.producer.SuperTransmitter;
import com.xdja.sc.model.Msg;
import com.xdja.spider.admin.service.IArticleService;
import com.xdja.spider.admin.service.IColumnService;
import com.xdja.spider.core.bean.Column;
import com.xdja.spider.core.util.UUIDUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GrabTask {
    private static Logger logger = LoggerFactory.getLogger(GrabTask.class);
    @Autowired
    private IColumnService columnService;
    @Autowired
    private IArticleService articleService;

    public void grab() {
        logger.debug("\u5b9a\u65f6\u4efb\u52a1\u5f00\u542f");
        List list = this.columnService.grabList();
        for (Column column : list) {
            String topic = null;
            try {
                if (column.getType() == Column.Type.GENERAL.value) {
                    topic = "grab.general";
                } else if (column.getType() == Column.Type.SPECIAL.value) {
                    topic = String.format("grab.special.%s.v%s", column.getSn());
                }
                int maxBatch = this.articleService.getMaxBatch(column.getId());
                SuperTransmitter.getInstance().sendMessage(topic, new Msg(UUIDUtil.random(), MQSetting.Queue, System.currentTimeMillis(), String.format("%s#%s", column.getId(), maxBatch + 1), null));
            }
            catch (Exception e) {
                logger.error("RMQ\u6d88\u606f\u53d1\u9001\u5931\u8d25", (Throwable)e);
            }
        }
    }
}

