/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.spider.robot.service.impl;

import com.xdja.spider.core.bean.Article;
import com.xdja.spider.core.bean.ArticleImg;
import com.xdja.spider.core.bean.GrabConf;
import com.xdja.spider.core.bean.GrabScript;
import com.xdja.spider.robot.dao.ISpiderRobotDao;
import com.xdja.spider.robot.service.ISpiderRobotService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SpiderRobotServiceImpl
implements ISpiderRobotService {
    @Autowired
    private ISpiderRobotDao spiderRobotDao;

    public GrabConf getGrabConf(Long colId) {
        return this.spiderRobotDao.getGrabConf(colId);
    }

    public GrabScript getGrabScript(String colSn) {
        return this.spiderRobotDao.getGrabScript(colSn);
    }

    public boolean saveArticle(List<Article> grabLists, int maxBatch) {
        ArrayList<Article> saveLists = new ArrayList<Article>();
        for (Article article : grabLists) {
            int isHas = this.spiderRobotDao.isArticleHas(article.getSn());
            if (isHas != 0) continue;
            saveLists.add(article);
        }
        if (CollectionUtils.isEmpty(saveLists)) {
            return false;
        }
        this.spiderRobotDao.saveArticle(saveLists);
        return true;
    }

    public void updateArticle(List<Article> articles) {
        this.spiderRobotDao.updateArticle(articles);
    }

    public List<Article> wait4GrabDetail(long colId) {
        return this.spiderRobotDao.wait4GrabDetail(colId, Article.ReleaseStatus.CLOSE.value);
    }

    public void saveArticleImgs(List<String> images) {
        ArrayList<ArticleImg> articleImgs = new ArrayList<ArticleImg>();
        for (String img : images) {
            ArticleImg articleImg = new ArticleImg();
            String[] split = img.split("#");
            articleImg.setArticleId(Long.valueOf(Long.parseLong(split[0])));
            articleImg.setImgUrl(split[1]);
            articleImgs.add(articleImg);
        }
        this.spiderRobotDao.saveArticleImgs(articleImgs);
    }

    public List<Article> wait4Static(long colId) {
        return this.spiderRobotDao.wait4Static(colId);
    }

    public void updateStaticTime(List<Article> article) {
        this.spiderRobotDao.updateStaticTime(article);
    }
}

