/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.spider.robot.grab;

import com.xdja.spider.core.bean.Article;
import com.xdja.spider.core.bean.GrabConf;
import com.xdja.spider.core.grab.GrabDetail;
import com.xdja.spider.core.grab.GrabUtil;
import com.xdja.spider.core.util.HtmlGenerator;
import com.xdja.spider.robot.service.ISpiderRobotService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class GrabHandle
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(GrabHandle.class);
    private long colId;
    private int maxBatch;
    private GrabConf grabConf;
    private ISpiderRobotService spiderRobotService;

    public GrabHandle(ISpiderRobotService spiderRobotService, long colId, int maxBatch) {
        this.spiderRobotService = spiderRobotService;
        this.colId = colId;
        this.maxBatch = maxBatch;
    }

    @Override
    public void run() {
        logger.debug("\u5f00\u59cb\u6293\u53d6:\u680f\u76ee\u3010{}\u3011\uff0c\u6279\u6b21\u3010{}\u3011", (Object)this.colId, (Object)this.maxBatch);
        this.grabConf = this.spiderRobotService.getGrabConf(Long.valueOf(this.colId));
        if (null == this.grabConf) {
            logger.error("\u6293\u53d6\u914d\u7f6e\u4e3a\u7a7a\uff0c\u505c\u6b62\u6293\u53d6:\u680f\u76ee\u3010{}\u3011\uff0c\u6279\u6b21\u3010{}\u3011", (Object)this.colId, (Object)this.maxBatch);
            return;
        }
        logger.debug("\u6293\u53d6\u5217\u8868:\u680f\u76ee\u3010{}\u3011\uff0c\u6279\u6b21\u3010{}\u3011", (Object)this.colId, (Object)this.maxBatch);
        this.grabList();
        logger.debug("\u6293\u53d6\u8be6\u60c5:\u680f\u76ee\u3010{}\u3011\uff0c\u6279\u6b21\u3010{}\u3011", (Object)this.colId, (Object)this.maxBatch);
        this.grabDetail();
        logger.debug("\u9759\u6001\u5316:\u680f\u76ee\u3010{}\u3011\uff0c\u6279\u6b21\u3010{}\u3011", (Object)this.colId, (Object)this.maxBatch);
        this.staticize();
    }

    private void staticize() {
        List list = this.spiderRobotService.wait4Static(this.colId);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        ArrayList<Article> success = new ArrayList<Article>();
        for (Article article : list) {
            try {
                HtmlGenerator.generateDefault((Object)article, (String)article.getViewUrl());
                article.setStaticTime(Long.valueOf(System.currentTimeMillis()));
                success.add(article);
            }
            catch (Exception e) {
                logger.error("\u9759\u6001\u5316\u5931\u8d25", (Throwable)e);
            }
        }
        this.spiderRobotService.updateStaticTime(success);
        this.staticize();
    }

    private void grabDetail() {
        List list = this.spiderRobotService.wait4GrabDetail(this.colId);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        ArrayList<Article> successResults = new ArrayList<Article>();
        ArrayList<String> images = new ArrayList<String>();
        for (Article article : list) {
            try {
                GrabDetail grabDetail = GrabUtil.grabDetail((String)article.getSourceUrl(), (GrabConf)this.grabConf);
                article.setContent(grabDetail.getContent());
                article.setDescription(grabDetail.getDescription());
                article.setTitle(grabDetail.getTitle());
                article.setReleaseTime(Long.valueOf(System.currentTimeMillis()));
                article.setReleaseStatus(Article.ReleaseStatus.RELEASE.value);
                List imgs = grabDetail.getImgs();
                if (!CollectionUtils.isEmpty((Collection)imgs)) {
                    for (String img : imgs) {
                        images.add(String.format("%s#%s", article.getId(), img));
                    }
                }
            }
            catch (IOException e) {
                article.setReleaseTime(null);
                article.setReleaseStatus(3);
                logger.error("\u8be6\u60c5\u6293\u53d6\u5931\u8d25", (Throwable)e);
            }
            successResults.add(article);
        }
        this.spiderRobotService.updateArticle(successResults);
        this.spiderRobotService.saveArticleImgs(images);
        this.grabDetail();
    }

    private void grabList() {
        try {
            List grabLists = GrabUtil.grabList((GrabConf)this.grabConf, (int)this.maxBatch);
            boolean isGo = this.spiderRobotService.saveArticle(grabLists, this.maxBatch);
            if (isGo && StringUtils.isNotEmpty((CharSequence)this.grabConf.getSourceUrl())) {
                logger.debug("\u7ee7\u7eed\u6293\u53d6:{}", (Object)this.grabConf.getSourceUrl());
                this.grabList();
            }
        }
        catch (IOException e) {
            logger.error("\u6293\u53d6\u5217\u8868\u5931\u8d25", (Throwable)e);
        }
    }
}

