/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.spider.robot.grab;

import com.xdja.spider.core.bean.GrabConf;
import com.xdja.spider.core.bean.GrabScript;
import com.xdja.spider.robot.grab.GrabHandle;
import com.xdja.spider.robot.grab.ScriptHandle;
import com.xdja.spider.robot.grab.SpecialHandle;
import com.xdja.spider.robot.service.ISpiderRobotService;
import com.xdja.spider.robot.special.GrabFactory;
import com.xdja.spider.robot.special.GrabSpecial;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Component;

@Component
public class GrabListener
implements MessageListener {
    private static Logger logger = LoggerFactory.getLogger(GrabListener.class);
    private static final ThreadPoolExecutor executor = new ThreadPoolExecutor(5, 50, 10L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>());
    @Autowired
    private ISpiderRobotService spiderRobotService;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    public void onMessage(Message message, byte[] pattern) {
        RedisSerializer valueSerializer = this.redisTemplate.getValueSerializer();
        Object body = valueSerializer.deserialize(message.getBody());
        Object channel = valueSerializer.deserialize(message.getChannel());
        try {
            String type = String.valueOf(channel);
            String content = String.valueOf(body);
            logger.debug("\u6d88\u606f\u5185\u5bb9\uff1a{}", (Object)content);
            if (type.equals("grab.general")) {
                String[] split = content.split("#");
                long colId = Long.parseLong(split[0]);
                int maxBatch = Integer.parseInt(split[1]);
                GrabConf grabConf = this.spiderRobotService.getGrabConf(Long.valueOf(colId));
                if (null == grabConf) {
                    logger.debug("\u65e0\u6293\u53d6\u914d\u7f6e\uff0c\u8df3\u8fc7\u2026\u2026");
                    return;
                }
                if (StringUtils.isNotEmpty((CharSequence)grabConf.getGrabClz())) {
                    GrabSpecial grab = GrabFactory.getGrab((String)grabConf.getGrabClz());
                    grab.grab(Long.valueOf(colId), Integer.valueOf(maxBatch));
                } else {
                    executor.execute(new GrabHandle(this.spiderRobotService, colId, maxBatch));
                }
            } else if (type.equals("grab.special.start")) {
                GrabScript grabScript = this.spiderRobotService.getGrabScript(content);
                ScriptHandle.handle(content, grabScript);
            } else if (type.equals("grab.special.handle")) {
                new SpecialHandle(this.spiderRobotService, Long.parseLong(content)).handle();
            }
        }
        catch (Exception e) {
            logger.error("\u6d88\u606f\u5904\u7406\u5931\u8d25", (Throwable)e);
        }
    }
}

