/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.spider.robot.grab;

import com.xdja.spider.core.bean.Article;
import com.xdja.spider.core.grab.GrabUtil;
import com.xdja.spider.core.grab.HtmlClear;
import com.xdja.spider.core.util.HtmlGenerator;
import com.xdja.spider.robot.service.ISpiderRobotService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class SpecialHandle {
    private static Logger logger = LoggerFactory.getLogger(SpecialHandle.class);
    private long colId;
    private ISpiderRobotService spiderRobotService;

    public SpecialHandle(ISpiderRobotService spiderRobotService, long colId) {
        this.spiderRobotService = spiderRobotService;
        this.colId = colId;
    }

    public void handle() {
        List list = this.spiderRobotService.wait4Static(this.colId);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        ArrayList<Article> successResults = new ArrayList<Article>();
        ArrayList<String> images = new ArrayList<String>();
        for (Article article : list) {
            String content = article.getContent();
            if (StringUtils.isEmpty((Object)content)) continue;
            Document parse = Jsoup.parse((String)content, (String)article.getSourceUrl());
            HtmlClear.clear((Element)parse);
            List imgs = GrabUtil.grabImgs((Elements)parse.getAllElements());
            if (!CollectionUtils.isEmpty((Collection)imgs)) {
                for (String img : imgs) {
                    images.add(String.format("%s#%s", article.getId(), img));
                }
            }
            content = parse.body().html();
            String description = parse.text();
            if (null != description) {
                article.setDescription(description.length() > 100 ? description.trim().substring(0, 100) : description.trim());
            }
            article.setContent(content);
            article.setReleaseTime(Long.valueOf(System.currentTimeMillis()));
            article.setReleaseStatus(Article.ReleaseStatus.RELEASE.value);
            try {
                HtmlGenerator.generateDefault((Object)article, (String)article.getViewUrl());
                article.setStaticTime(Long.valueOf(System.currentTimeMillis()));
            }
            catch (Exception e) {
                logger.debug("\u9759\u6001\u5316\u5931\u8d25", (Throwable)e);
            }
            successResults.add(article);
        }
        this.spiderRobotService.updateArticle(successResults);
        logger.info("\u4fee\u6539\u6570\u636e");
        this.spiderRobotService.saveArticleImgs(images);
        logger.info("\u4fdd\u5b58\u56fe\u7247");
        this.spiderRobotService.updateStaticTime(successResults);
        logger.info("\u4fee\u6539\u9759\u6001\u5316\u65f6\u95f4");
        this.handle();
    }
}

