/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.spider.robot.init;

import com.xdja.spider.core.util.FastDFSUtil;
import com.xdja.spider.core.util.HtmlGenerator;
import com.xdja.spider.robot.grab.ScriptHandle;
import com.xdja.spider.robot.special.GrabFactory;
import com.xdja.spider.robot.special.GrabSpecial;
import java.util.Collection;
import java.util.Properties;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.stereotype.Service;

@Service
public class RobotInit
implements InitializingBean {
    private static Logger logger = LoggerFactory.getLogger(RobotInit.class);
    @Resource
    private ApplicationContext application;

    public void afterPropertiesSet() throws Exception {
        Properties properties = PropertiesLoaderUtils.loadAllProperties((String)"system.properties");
        String fastdfsHost = properties.getProperty("fastdfs.host");
        String fastdfsUserId = properties.getProperty("fastdfs.user.id");
        String fastdfsUserSecret = properties.getProperty("fastdfs.user.secret");
        String forwarddownhost = properties.getProperty("forward.down.host");
        logger.debug("##########################");
        logger.debug("\u521d\u59cb\u5316FastDFS:{}", (Object)fastdfsHost);
        FastDFSUtil.init((String)forwarddownhost, (String)fastdfsHost, (String)fastdfsUserId, (String)fastdfsUserSecret);
        String staticPath = properties.getProperty("static.path");
        logger.debug("##########################");
        logger.debug("\u9759\u6001\u5316\u6587\u4ef6\u4fdd\u5b58\u8def\u5f84:{}", (Object)staticPath);
        HtmlGenerator.init((String)staticPath);
        String scriptPath = properties.getProperty("script.path");
        logger.debug("##########################");
        logger.debug("\u7279\u6b8a\u811a\u672c\u6587\u4ef6\u8def\u5f84:{}", (Object)scriptPath);
        ScriptHandle.init(scriptPath);
        Collection grabs = this.application.getBeansOfType(GrabSpecial.class).values();
        logger.debug("\u626b\u63cf\u5230\u7279\u6b8a\u6293\u53d6\u65b9\u6cd5\u6570\u91cf\uff1a{}", (Object)grabs.size());
        GrabFactory.grabs.clear();
        for (GrabSpecial grab : grabs) {
            GrabFactory.putGrab((String)grab.name(), (GrabSpecial)grab);
        }
    }
}

