package com.xdja.spider.view.dao;

import com.xdja.spider.view.bean.ArticleDetail;
import com.xdja.spider.view.bean.ArticleList;
import com.xdja.spider.view.bean.Column;
import org.jfaster.mango.annotation.DB;
import org.jfaster.mango.annotation.SQL;

import java.util.List;

/**
 * TODO hsun 完成注释
 *
 * @author hsun
 * @version 1.0
 * @since 2017/7/12 下午4:24
 */
@DB
public interface ISpiderViewDao {


    @SQL("SELECT " +
            " col.n_id AS id, " +
            " pub.n_id AS publisherId, " +
            " col.c_name AS NAME, " +
            " col.n_status AS STATUS, " +
            " col.n_is_public AS isPublic, " +
            " col.c_icon AS icon, " +
            " col.c_info AS info, " +
            " col.c_sn AS sn, " +
            " col.n_type AS type, " +
            " col.n_create_time AS createTime, " +
            " col.n_seq AS seq, " +
            " col.n_article_add_time AS articleAddTime " +
            "FROM " +
            " t_column col " +
            "LEFT JOIN t_publisher pub ON col.n_publisher_id = pub.n_id " +
            "WHERE " +
            " pub.c_sn = :1 " +
            "AND col.n_status = 1 ")
    List<Column> columnList(String sn);

    @SQL("SELECT " +
            " col.n_id AS id, " +
            " pub.n_id AS publisherId, " +
            " col.c_name AS NAME, " +
            " col.n_status AS STATUS, " +
            " col.n_is_public AS isPublic, " +
            " col.c_icon AS icon, " +
            " col.c_info AS info, " +
            " col.c_sn AS sn, " +
            " col.n_type AS type, " +
            " col.n_create_time AS createTime, " +
            " col.n_seq AS seq, " +
            " col.n_article_add_time AS articleAddTime " +
            "FROM " +
            " t_column col " +
            "LEFT JOIN t_publisher pub ON col.n_publisher_id = pub.n_id " +
            "WHERE " +
            " col.n_id = :1 " )
    Column getColumn(Long colId);

    @SQL("SELECT " +
            " n_id AS id, " +
            " n_column_id AS columnId, " +
            " c_title AS title, " +
            " c_date AS date, " +
            " c_view_url AS viewUrl, " +
            " c_sn AS sn, " +
            " c_description AS description, " +
            " n_grab_batch AS grabBatch " +
            "FROM " +
            " t_article " +
            "WHERE " +
            " n_column_id = :1 " +
            "AND n_static_time IS NOT NULL " +
            "ORDER BY n_grab_batch DESC, n_id LIMIT 0, :2")
    List<ArticleList> articleList(Long colId, int pageSize);

    @SQL("SELECT " +
            " n_id AS id, " +
            " n_column_id AS columnId, " +
            " c_title AS title, " +
            " c_date AS date, " +
            " c_view_url AS viewUrl, " +
            " c_sn AS sn, " +
            " c_description AS description, " +
            " n_grab_batch AS grabBatch " +
            "FROM " +
            " t_article " +
            "WHERE " +
            " n_column_id = :1 " +
            "AND n_static_time IS NOT NULL " +
            "AND ( " +
            "  (n_grab_batch = :2 && n_id > :3) " +
            "  OR (n_grab_batch < :2 && n_id < :4) " +
            ") " +
            "ORDER BY n_grab_batch DESC, n_id LIMIT 0, :5")
    List<ArticleList> pullUp(Long colId, int batch, long gtId, long ltId, int pageSize);

    @SQL("SELECT " +
            " article.n_id AS id, " +
            " article.c_title AS title, " +
            " article.c_content AS content, " +
            " article.c_view_url AS viewUrl, " +
            " article.c_source_url AS sourceUrl, " +
            " article.c_sn AS sn, " +
            " col.n_id AS columnId, " +
            " col.c_name AS columnName " +
            "FROM " +
            " t_article article " +
            "LEFT JOIN t_column col ON article.n_column_id = col.n_id " +
            "WHERE " +
            " article.n_id = :1 ")
    ArticleDetail articleDetail(Long id);

    @SQL("SELECT c_img_url AS imgUrl FROM t_article_img WHERE n_article_id = :1 ")
    List<String> getArticleImgs(Long articleId);
}
