package com.xdja.spider.view.service.impl;

import com.xdja.spider.view.bean.*;
import com.xdja.spider.view.dao.ISpiderViewDao;
import com.xdja.spider.view.service.ISpiderViewService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * TODO hsun 完成注释
 *
 * @author hsun
 * @version 1.0
 * @since 2017/7/12 下午4:18
 */
@Service
public class SpiderViewServiceImpl implements ISpiderViewService {

    @Autowired
    private ISpiderViewDao viewDao;

    @Override
    public List<Column> columnList(String sn) {
        return this.viewDao.columnList(sn);
    }

    @Override
    public Column columnDetail(Long id) {
        return this.viewDao.getColumn(id);
    }

    @Override
    public ArticleListResponse articleList(ArticleListRequest listRequest) {
        ArticleListResponse listResponse = new ArticleListResponse();
        List<ArticleList> list = null;

        if (null == listRequest.getType()) {
            list = this.viewDao.articleList(listRequest.getColId(), listRequest.getPageSize() + 1);
        } else {
//            Column column = this.viewDao.getColumn(listRequest.getColId());
//            if (column.getType() != Column.Type.MANUAL.value) {

            if (listRequest.getType() == ArticleListRequest.Type.PULLUP.value ) {//上拉加载更多
//                int batch = listRequest.getLastBatch();
//                long gtId = listRequest.getLastId();
                long ltId = listRequest.getFirstBatch() == listRequest.getLastBatch()
                        ? listRequest.getLastId() : listRequest.getFirstId();

                list = this.viewDao.pullUp(listRequest.getColId(), listRequest.getLastBatch(), listRequest.getLastId(),
                        ltId, listRequest.getPageSize() + 1);
            } else {//下拉加载最新

            }
//            } else { //手动发布新闻
//
//            }
        }

        listResponse.setHasMore(list.size() > listRequest.getPageSize());
        if (list.size() > 1) {
            list.remove(list.size()-1);
        }

        for (ArticleList articleList : list) {
            List<String> imgs = this.viewDao.getArticleImgs(articleList.getId());
            if (CollectionUtils.isEmpty(imgs)) {
                articleList.setType(ArticleList.Type.TEXT.value);
            } else {
                if (imgs.size() == 1) {
                    articleList.setType(ArticleList.Type.ONEIMGS.value);
                } else if (imgs.size() == 2){
                    articleList.setType(ArticleList.Type.ONEIMGS.value);
                    imgs.remove(1);
                } else if (imgs.size() == 3){
                    articleList.setType(ArticleList.Type.THREEIMGS.value);
                } else if (imgs.size() > 3){
                    articleList.setType(ArticleList.Type.THREEIMGS.value);
                    List<String> images = imgs.subList(0, 3);
                    imgs = images;
                }
            }
            articleList.setImgs(imgs);
        }

        listResponse.setList(list);

        return listResponse;
    }

    @Override
    public ArticleDetail articleDetail(Long id) {
        return this.viewDao.articleDetail(id);
    }
}
