/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.spider.view.service.impl;

import com.xdja.spider.view.bean.ArticleDetail;
import com.xdja.spider.view.bean.ArticleList;
import com.xdja.spider.view.bean.ArticleListRequest;
import com.xdja.spider.view.bean.ArticleListResponse;
import com.xdja.spider.view.bean.Column;
import com.xdja.spider.view.dao.ISpiderViewDao;
import com.xdja.spider.view.service.ISpiderViewService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SpiderViewServiceImpl
implements ISpiderViewService {
    @Autowired
    private ISpiderViewDao viewDao;

    public List<Column> columnList(String sn) {
        return this.viewDao.columnList(sn);
    }

    public Column columnDetail(Long id) {
        return this.viewDao.getColumn(id);
    }

    public ArticleListResponse articleList(ArticleListRequest listRequest) {
        ArticleListResponse listResponse = new ArticleListResponse();
        List<ArticleList> list = null;
        if (null == listRequest.getType()) {
            list = this.viewDao.articleList(listRequest.getColId(), listRequest.getPageSize() + 1);
        } else if (listRequest.getType() == ArticleListRequest.Type.PULLUP.value) {
            long ltId = listRequest.getFirstBatch() == listRequest.getLastBatch() ? listRequest.getLastId() : listRequest.getFirstId();
            list = this.viewDao.pullUp(listRequest.getColId(), listRequest.getLastBatch(), listRequest.getLastId(), ltId, listRequest.getPageSize() + 1);
        }
        listResponse.setHasMore(list.size() > listRequest.getPageSize());
        if (list.size() > listRequest.getPageSize()) {
            list.remove(listRequest.getPageSize());
        }
        for (ArticleList articleList : list) {
            articleList.setViewUrl(String.format("%s%s", ArticleList.DETAIL_URL_PREFIX, articleList.getViewUrl()));
            List<String> imgs = this.viewDao.getArticleImgs(articleList.getId());
            if (CollectionUtils.isEmpty(imgs)) {
                articleList.setType(ArticleList.Type.TEXT.value);
            } else if (imgs.size() == 1) {
                articleList.setType(ArticleList.Type.ONEIMGS.value);
            } else if (imgs.size() == 2) {
                articleList.setType(ArticleList.Type.ONEIMGS.value);
                imgs.remove(1);
            } else if (imgs.size() == 3) {
                articleList.setType(ArticleList.Type.THREEIMGS.value);
            } else if (imgs.size() > 3) {
                articleList.setType(ArticleList.Type.THREEIMGS.value);
                List<String> images = imgs.subList(0, 3);
                imgs = images;
            }
            for (int i = 0; i < imgs.size(); ++i) {
                imgs.set(i, String.format("%s/%s", ArticleList.FASTDFS_DOWN_HOST, imgs.get(i)));
            }
            articleList.setImgs(imgs);
        }
        listResponse.setList(list);
        return listResponse;
    }

    public ArticleDetail articleDetail(Long id) {
        return this.viewDao.articleDetail(id);
    }
}

