package com.xdja.spider.view.control;

import com.xdja.spider.view.bean.*;
import com.xdja.spider.view.service.ISpiderViewService;
import org.jfaster.mango.plugin.page.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 展示控制
 *
 * @author hsun
 * @version 1.0
 * @since 2017/7/12 下午4:11
 */
@Controller
public class SpiderViewControl {

    @Autowired
    private ISpiderViewService spiderViewService;

    //-------------------------------------接口数据-------------------------------------
    @RequestMapping(value = "/column/list", method = RequestMethod.GET)
    @ResponseBody
    public List columnList(String publisherSn) {
        return this.spiderViewService.columnList(publisherSn);
    }

    @RequestMapping(value = "/column/{id}/detail", method = RequestMethod.GET)
    @ResponseBody
    public Column columnDetail(@PathVariable Long id) {
        return this.spiderViewService.columnDetail(id);
    }

    @RequestMapping(value = "/article/list", method = RequestMethod.GET)
    @ResponseBody
    public ArticleListResponse articleListForm(ArticleListRequest listRequest) {
        return this.spiderViewService.articleList(listRequest);
    }

    @RequestMapping(value = "/article/list", method = RequestMethod.POST)
    @ResponseBody
    public ArticleListResponse articleListJSON(@RequestBody ArticleListRequest listRequest) {
        return this.spiderViewService.articleList(listRequest);
    }

    @RequestMapping(value = "/article/{id}/detail", method = RequestMethod.GET)
    @ResponseBody
    public ArticleDetail articleDetail(@PathVariable Long id) {
        return this.spiderViewService.articleDetail(id);
    }


//    public Object query(String keyWord, List<Long> colIds) {
//        return this.spiderViewService.query(keyWord, colIds);
//    }


    //-------------------------------------页面数据-------------------------------------
}
