/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.transfer;

import com.alibaba.fastjson.JSONObject;
import com.xdja.common.logger.LoggerUtil;
import com.xdja.transfer.PreloadService;
import com.xdja.transfer.TransferListener;
import com.xdja.transfer.annotation.TransferMethod;
import com.xdja.transfer.constant.ExecuteTransferRequestStatus;
import com.xdja.transfer.entity.MessageBody;
import com.xdja.transfer.entity.TransferBussinessCfg;
import com.xdja.transfer.entity.TransferData;
import com.xdja.transfer.entity.TransferMessage;
import com.xdja.transfer.util.Utils;

public abstract class AbstractTransferListener
implements TransferListener {
    protected PreloadService preloadService;
    protected TransferBussinessCfg transferBussinessCfg;

    @Override
    public void initCfg(TransferMethod transferMethod) {
        this.transferBussinessCfg = new TransferBussinessCfg();
        this.transferBussinessCfg.setIgnoreExceptionClasses(transferMethod.ignoreExceptionClasses());
        this.transferBussinessCfg.setResIsHandle(transferMethod.resIsHandle());
        this.transferBussinessCfg.setResKey(transferMethod.resKey());
        this.transferBussinessCfg.setResValues(transferMethod.resValues());
    }

    @Override
    public PreloadService getPreloadService() {
        return this.preloadService;
    }

    @Override
    public void setPreloadService(PreloadService preloadService) {
        this.preloadService = preloadService;
    }

    @Override
    public ExecuteTransferRequestStatus executeTransferRequest(String data) {
        MessageBody messageBody = (MessageBody)JSONObject.parseObject((String)data, MessageBody.class);
        this.preloadService.preloadCache(messageBody.getRedisInfo());
        try {
            Object result = this.execute(messageBody.getArgs());
            if (this.transferBussinessCfg.isResIsHandle()) {
                return Utils.proceed(result, this.transferBussinessCfg.getResKey(), this.transferBussinessCfg.getResValues()) ? ExecuteTransferRequestStatus.EXE_SUCCESS : ExecuteTransferRequestStatus.RETRY_LATER;
            }
            return ExecuteTransferRequestStatus.EXE_SUCCESS;
        }
        catch (Throwable e) {
            LoggerUtil.error((String)"executeTransferRequest error,detail:{}", (Object[])new Object[]{e.getMessage()});
            return this.ignoreException(e, this.transferBussinessCfg.getIgnoreExceptionClasses()) ? ExecuteTransferRequestStatus.EXE_SUCCESS : ExecuteTransferRequestStatus.RETRY_LATER;
        }
    }

    @Override
    public boolean executeLocalTransaction(TransferMessage transferMessage, TransferData data) throws Throwable {
        try {
            data.setData(data.getJoinPoint().proceed(data.getArgs()));
        }
        catch (Throwable e) {
            data.setE(e);
            LoggerUtil.error((String)"executeLocalTransaction error,detail:{}", (Object[])new Object[]{e.getMessage()});
            return this.ignoreException(e, this.transferBussinessCfg.getIgnoreExceptionClasses());
        }
        if (this.transferBussinessCfg.isResIsHandle()) {
            return Utils.proceed(data.getData(), this.transferBussinessCfg.getResKey(), this.transferBussinessCfg.getResValues());
        }
        return true;
    }

    protected boolean ignoreException(Throwable e, Class[] ignoreExceptionClasses) {
        for (Class clazz : ignoreExceptionClasses) {
            if (!clazz.isInstance(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean checkLocalTransaction(TransferMessage transferMessage) {
        return false;
    }
}

