/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.transfer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.common.logger.LoggerUtil;
import com.xdja.transfer.TransferListener;
import com.xdja.transfer.annotation.TransferComponent;
import com.xdja.transfer.annotation.TransferMethod;
import com.xdja.transfer.asm.AsmTransferListenerGenerator;
import com.xdja.transfer.asm.TransferASMClassLoader;
import com.xdja.transfer.context.TransferContext;
import com.xdja.transfer.entity.Account;
import com.xdja.transfer.exception.BaseException;
import com.xdja.transfer.exception.ParameterException;
import com.xdja.transfer.exception.UnsupportedException;
import com.xdja.transfer.service.TransferService;
import com.xdja.transfer.service.impl.TransferServiceImpl;
import com.xdja.transfer.util.HttpUtils;
import com.xdja.transfer.util.Utils;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.TypeAnnotationsScanner;

public class Transfer {
    private final TransferContext context = new TransferContext();
    private final TransferService service = new TransferServiceImpl();
    private final HttpUtils httpUtils = new HttpUtils();
    private final AsmTransferListenerGenerator generator = new AsmTransferListenerGenerator(new TransferASMClassLoader());

    public static Transfer getInstance() {
        return InstanceFactory.instance;
    }

    public boolean initialize(String platform, String module, String nameServerAddr, String path, String tfServerAddr) {
        if (StringUtils.isEmpty((CharSequence)module)) {
            LoggerUtil.error((String)"The module is empty.", (Object[])new Object[0]);
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)nameServerAddr)) {
            LoggerUtil.error((String)"The nameServerAddr is empty.", (Object[])new Object[0]);
            return false;
        }
        this.context.setCurrentPlatfrom(platform);
        this.context.setCurrentModule(module);
        this.context.setNameServerAddr(nameServerAddr);
        this.context.setTransferServerAddr(tfServerAddr);
        this.registerToTransferServer();
        this.initSupportedPlatforms();
        this.addListenersToContext(path);
        this.generatedMethodClasses(path);
        return this.service.initialize(this.context);
    }

    public Map<String, Set<Account>> accountSorting(List<Account> orgAccounts) throws BaseException {
        if (orgAccounts == null || orgAccounts.isEmpty()) {
            LoggerUtil.warn((String)"orgAccounts is empty.", (Object[])new Object[0]);
            throw new ParameterException("orgAccounts is empty.");
        }
        try {
            this.checkSupportedPlatforms(this.context.getPlatforms(), orgAccounts);
        }
        catch (UnsupportedException e) {
            this.checkSupportedPlatforms(this.initSupportedPlatforms(), orgAccounts);
        }
        return this.service.accountSorting(orgAccounts);
    }

    public Set<String> getSupportedPlatforms() {
        Set<String> platforms = this.context.getPlatforms();
        if (platforms.isEmpty()) {
            platforms = this.initSupportedPlatforms();
        }
        return platforms;
    }

    public void distribute(String flag, String body, Object result) {
        if (StringUtils.isEmpty((CharSequence)flag) || StringUtils.isEmpty((CharSequence)body) || result == null) {
            LoggerUtil.warn((String)"params error: flag, body or result is empty.", (Object[])new Object[0]);
            throw new ParameterException();
        }
        if (!this.context.isRegisted()) {
            this.registerToTransferServer();
        }
        this.service.distribute(flag, body, result);
    }

    public void duplicate(String flag, String body, Object result) {
        if (StringUtils.isEmpty((CharSequence)flag) || StringUtils.isEmpty((CharSequence)body) || result == null) {
            LoggerUtil.warn((String)"params error: flag, body or result is empty.", (Object[])new Object[0]);
            throw new ParameterException();
        }
        if (!this.context.isRegisted()) {
            this.registerToTransferServer();
        }
        this.service.duplicate(flag, body, result);
    }

    public boolean checkIsTransferReq() {
        return this.context.getIsTransfer();
    }

    public void setReqTransfer() {
        this.context.setIsTransfer(false);
    }

    private void checkSupportedPlatforms(Set<String> platforms, List<Account> orgAccounts) throws UnsupportedException {
        for (Account account : orgAccounts) {
            if (platforms.contains(account.getPlatform())) continue;
            throw new UnsupportedException();
        }
    }

    private void registerToTransferServer() {
        LoggerUtil.info((String)"register module:{} into transfer-server...", (Object[])new Object[]{this.context.getCurrentModule()});
        try {
            long code;
            String response = this.httpUtils.post(this.context.getRegisterApiAddr(), this.context.getCurrentModule());
            LoggerUtil.warn((String)"response:{}", (Object[])new Object[]{response});
            JSONObject respJsonObj = JSONObject.parseObject((String)response);
            if (respJsonObj != null && (code = respJsonObj.getLong("code").longValue()) == 200L) {
                this.context.setRegisted(true);
            }
        }
        catch (Exception e) {
            LoggerUtil.error((String)"exception detail: {}", (Object[])new Object[]{Utils.getStackTrace(e)});
        }
    }

    private void addListenersToContext(String path) {
        Reflections reflections = new Reflections(path, new Scanner[0]);
        Set classSet = reflections.getTypesAnnotatedWith(TransferComponent.class);
        for (Class clazz : classSet) {
            TransferComponent component = clazz.getAnnotation(TransferComponent.class);
            if (StringUtils.isEmpty((CharSequence)component.flag())) {
                throw new RuntimeException("listener's flag can't be empty");
            }
            if (this.context.getListener(component.flag()) != null) {
                throw new RuntimeException("listener's flag is duplicated");
            }
            try {
                this.context.addListener(component.flag(), (TransferListener)clazz.newInstance());
            }
            catch (Exception e) {
                LoggerUtil.error((String)"exception detail: {}", (Object[])new Object[]{Utils.getStackTrace(e)});
            }
        }
    }

    private Set<String> initSupportedPlatforms() {
        LoggerUtil.info((String)"init supported platforms from transfer-server...", (Object[])new Object[0]);
        HashSet<String> platforms = new HashSet<String>();
        try {
            long code;
            String response = this.httpUtils.get(this.context.getSupportedPlatformsAddr());
            LoggerUtil.warn((String)"response:{}", (Object[])new Object[]{response});
            JSONObject respJsonObj = JSONObject.parseObject((String)response);
            if (respJsonObj != null && (code = respJsonObj.getLong("code").longValue()) == 200L) {
                String data = respJsonObj.getString("data");
                if (StringUtils.isEmpty((CharSequence)data)) {
                    LoggerUtil.warn((String)"get supported platforms is empty.", (Object[])new Object[0]);
                    return platforms;
                }
                JSONArray dataArray = JSONArray.parseArray((String)data);
                if (dataArray == null || dataArray.isEmpty()) {
                    LoggerUtil.warn((String)"parse data into the JSONArray is empty.", (Object[])new Object[0]);
                    return platforms;
                }
                for (int i = 0; i < dataArray.size(); ++i) {
                    JSONObject platform = dataArray.getJSONObject(i);
                    platforms.add(platform.getString("platformName"));
                }
                if (!platforms.isEmpty()) {
                    this.context.setPlatforms(platforms);
                }
            }
        }
        catch (Exception e) {
            LoggerUtil.error((String)"exception detail: {}", (Object[])new Object[]{Utils.getStackTrace(e)});
        }
        return platforms;
    }

    private void generatedMethodClasses(String path) {
        Reflections reflections = new Reflections(path, new Scanner[]{new MethodAnnotationsScanner(), new TypeAnnotationsScanner()});
        Set methodSet = reflections.getMethodsAnnotatedWith(TransferMethod.class);
        for (Method method : methodSet) {
            TransferMethod transferMethod = method.getAnnotation(TransferMethod.class);
            Class<?> aClass = this.generator.generateBussinesssClass(method, transferMethod.transferName(), transferMethod.generateType());
            try {
                TransferListener listener = (TransferListener)aClass.newInstance();
                listener.setPreloadService(transferMethod.preClass().newInstance());
                listener.initCfg(transferMethod);
                this.context.addListener(transferMethod.transferName(), listener);
            }
            catch (Exception e) {
                LoggerUtil.error((String)"exception detail: {}", (Object[])new Object[]{Utils.getStackTrace(e)});
            }
        }
    }

    public void shutdown() {
        this.service.shutdown();
    }

    private Transfer() {
    }

    public static void main(String[] args) {
        Transfer.getInstance().initialize("sjw", "bb", "cc", "com.xdja", "dd");
    }

    private static class InstanceFactory {
        private static final Transfer instance = new Transfer();

        private InstanceFactory() {
        }
    }
}

