/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.transfer.asm;

import com.xdja.common.logger.LoggerUtil;
import com.xdja.transfer.asm.GenerateCodeTypeEnum;
import com.xdja.transfer.asm.TransferASMClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class AsmTransferListenerGenerator {
    public static final String GENERATE_CLASS_PACKAGE = "com/xdja/transfer/asm/";
    public static final String DEFINE_CLASS_PACKAGE = "com.xdja.transfer.asm.";
    public static final String TYPE_INT = "int";
    public static final String TYPE_LONG = "long";
    public static final String TYPE_CHAR = "char";
    public static final String TYPE_BYTE = "byte";
    public static final String TYPE_SHORT = "short";
    public static final String TYPE_FLOAT = "float";
    public static final String TYPE_DOUBLE = "double";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_STRING = "java/lang/String";
    public static final String PACK_TYPE_INT = "java/lang/Integer";
    public static final String PACK_TYPE_LONG = "java/lang/Long";
    public static final String PACK_TYPE_CHAR = "java/lang/Character";
    public static final String PACK_TYPE_BYTE = "java/lang/Byte";
    public static final String PACK_TYPE_SHORT = "java/lang/Short";
    public static final String PACK_TYPE_FLOAT = "java/lang/Float";
    public static final String PACK_TYPE_DOUBLE = "java/lang/Double";
    public static final String PACK_TYPE_BOOLEAN = "java/lang/Boolean";
    public final TransferASMClassLoader asmClassLoader;

    public AsmTransferListenerGenerator(ClassLoader parentClassLoader) {
        this.asmClassLoader = parentClassLoader instanceof TransferASMClassLoader ? (TransferASMClassLoader)parentClassLoader : new TransferASMClassLoader(parentClassLoader);
    }

    public Class<?> generateBussinesssClass(Method method, String generateClassName, GenerateCodeTypeEnum generateType) {
        String parentClassPath = Type.getInternalName(method.getDeclaringClass());
        String parentClassDesc = Type.getDescriptor(method.getDeclaringClass());
        String methodName = method.getName();
        String generateClassOwner = GENERATE_CLASS_PACKAGE + generateClassName;
        String generateClassDesc = "Lcom/xdja/transfer/asm/" + generateClassName + ";";
        String defineClassPath = DEFINE_CLASS_PACKAGE + generateClassName;
        Class<?>[] parameterTypes = method.getParameterTypes();
        String generateParentClassDesc = null;
        generateParentClassDesc = generateType == GenerateCodeTypeEnum.GENERATE_CODE_TYPE_NORMAL ? "com/xdja/transfer/AbstractTransferListener" : "com/xdja/transfer/AbstractTransferAspectListener";
        ClassWriter classWriter = new ClassWriter(2);
        classWriter.visit(52, 33, generateClassOwner, null, generateParentClassDesc, null);
        classWriter.visitSource(generateClassName + ".java", null);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "()V", null, null);
        methodVisitor.visitCode();
        Label label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, generateParentClassDesc, "<init>", "()V", false);
        methodVisitor.visitInsn(177);
        Label label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitLocalVariable("this", generateClassDesc, null, label0, label1, 0);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "execute", "([Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, generateClassOwner, "preloadService", "Lcom/xdja/transfer/PreloadService;");
        methodVisitor.visitLdcInsn((Object)Type.getType((String)parentClassDesc));
        methodVisitor.visitMethodInsn(185, "com/xdja/transfer/PreloadService", "preloadBean", "(Ljava/lang/Class;)Ljava/lang/Object;", true);
        methodVisitor.visitTypeInsn(192, parentClassPath);
        methodVisitor.visitVarInsn(58, 2);
        label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitVarInsn(25, 2);
        for (int i = 0; i < parameterTypes.length; ++i) {
            String paramType = Type.getInternalName(parameterTypes[i]);
            if (TYPE_INT.equals(paramType)) {
                paramType = Type.getInternalName(Integer.class);
                methodVisitor.visitTypeInsn(187, paramType);
                methodVisitor.visitInsn(89);
                this.commonSet(methodVisitor, i);
                methodVisitor.visitMethodInsn(182, "java/lang/Object", "toString", "()Ljava/lang/String;", false);
                methodVisitor.visitMethodInsn(183, paramType, "<init>", "(Ljava/lang/String;)V", false);
                methodVisitor.visitMethodInsn(182, paramType, "intValue", "()I", false);
            } else if (TYPE_LONG.equals(paramType)) {
                paramType = Type.getInternalName(Long.class);
                methodVisitor.visitTypeInsn(187, paramType);
                methodVisitor.visitInsn(89);
                this.commonSet(methodVisitor, i);
                methodVisitor.visitMethodInsn(182, "java/lang/Object", "toString", "()Ljava/lang/String;", false);
                methodVisitor.visitMethodInsn(183, paramType, "<init>", "(Ljava/lang/String;)V", false);
                methodVisitor.visitMethodInsn(182, paramType, "longValue", "()J", false);
            } else if (TYPE_BYTE.equals(paramType)) {
                paramType = Type.getInternalName(Byte.class);
                methodVisitor.visitTypeInsn(187, paramType);
                methodVisitor.visitInsn(89);
                this.commonSet(methodVisitor, i);
                methodVisitor.visitMethodInsn(182, "java/lang/Object", "toString", "()Ljava/lang/String;", false);
                methodVisitor.visitMethodInsn(183, paramType, "<init>", "(Ljava/lang/String;)V", false);
                methodVisitor.visitMethodInsn(182, paramType, "byteValue", "()B", false);
            } else if (TYPE_CHAR.equals(paramType)) {
                paramType = Type.getInternalName(Character.class);
                methodVisitor.visitTypeInsn(187, paramType);
                methodVisitor.visitInsn(89);
                this.commonSet(methodVisitor, i);
                methodVisitor.visitMethodInsn(182, "java/lang/Object", "toString", "()Ljava/lang/String;", false);
                methodVisitor.visitMethodInsn(183, paramType, "<init>", "(Ljava/lang/String;)V", false);
                methodVisitor.visitMethodInsn(182, paramType, "charValue", "()C", false);
            } else if (TYPE_BOOLEAN.equals(paramType)) {
                paramType = Type.getInternalName(Boolean.class);
                methodVisitor.visitTypeInsn(187, paramType);
                methodVisitor.visitInsn(89);
                this.commonSet(methodVisitor, i);
                methodVisitor.visitMethodInsn(182, "java/lang/Object", "toString", "()Ljava/lang/String;", false);
                methodVisitor.visitMethodInsn(183, paramType, "<init>", "(Ljava/lang/String;)V", false);
                methodVisitor.visitMethodInsn(182, paramType, "booleanValue", "()Z", false);
            } else if (TYPE_SHORT.equals(paramType)) {
                paramType = Type.getInternalName(Short.class);
                methodVisitor.visitTypeInsn(187, paramType);
                methodVisitor.visitInsn(89);
                this.commonSet(methodVisitor, i);
                methodVisitor.visitMethodInsn(182, "java/lang/Object", "toString", "()Ljava/lang/String;", false);
                methodVisitor.visitMethodInsn(183, paramType, "<init>", "(Ljava/lang/String;)V", false);
                methodVisitor.visitMethodInsn(182, paramType, "shortValue", "()S", false);
            } else if (TYPE_FLOAT.equals(paramType)) {
                paramType = Type.getInternalName(Float.class);
                methodVisitor.visitTypeInsn(187, paramType);
                methodVisitor.visitInsn(89);
                this.commonSet(methodVisitor, i);
                methodVisitor.visitMethodInsn(182, "java/lang/Object", "toString", "()Ljava/lang/String;", false);
                methodVisitor.visitMethodInsn(183, paramType, "<init>", "(Ljava/lang/String;)V", false);
                methodVisitor.visitMethodInsn(182, paramType, "floatValue", "()F", false);
            } else if (TYPE_DOUBLE.equals(paramType)) {
                paramType = Type.getInternalName(Double.class);
                methodVisitor.visitTypeInsn(187, paramType);
                methodVisitor.visitInsn(89);
                this.commonSet(methodVisitor, i);
                methodVisitor.visitMethodInsn(182, "java/lang/Object", "toString", "()Ljava/lang/String;", false);
                methodVisitor.visitMethodInsn(183, paramType, "<init>", "(Ljava/lang/String;)V", false);
                methodVisitor.visitMethodInsn(182, paramType, "doubleValue", "()D", false);
            } else if (PACK_TYPE_INT.equals(paramType)) {
                paramType = Type.getInternalName(Integer.class);
                methodVisitor.visitTypeInsn(187, paramType);
                methodVisitor.visitInsn(89);
                this.commonSet(methodVisitor, i);
                methodVisitor.visitMethodInsn(182, "java/lang/Object", "toString", "()Ljava/lang/String;", false);
                methodVisitor.visitMethodInsn(183, paramType, "<init>", "(Ljava/lang/String;)V", false);
            } else if (PACK_TYPE_LONG.equals(paramType)) {
                paramType = Type.getInternalName(Long.class);
                methodVisitor.visitTypeInsn(187, paramType);
                methodVisitor.visitInsn(89);
                this.commonSet(methodVisitor, i);
                methodVisitor.visitMethodInsn(182, "java/lang/Object", "toString", "()Ljava/lang/String;", false);
                methodVisitor.visitMethodInsn(183, paramType, "<init>", "(Ljava/lang/String;)V", false);
            } else if (PACK_TYPE_BYTE.equals(paramType)) {
                paramType = Type.getInternalName(Byte.class);
                methodVisitor.visitTypeInsn(187, paramType);
                methodVisitor.visitInsn(89);
                this.commonSet(methodVisitor, i);
                methodVisitor.visitMethodInsn(182, "java/lang/Object", "toString", "()Ljava/lang/String;", false);
                methodVisitor.visitMethodInsn(183, paramType, "<init>", "(Ljava/lang/String;)V", false);
            } else if (PACK_TYPE_CHAR.equals(paramType)) {
                paramType = Type.getInternalName(Character.class);
                methodVisitor.visitTypeInsn(187, paramType);
                methodVisitor.visitInsn(89);
                this.commonSet(methodVisitor, i);
                methodVisitor.visitMethodInsn(182, "java/lang/Object", "toString", "()Ljava/lang/String;", false);
                methodVisitor.visitMethodInsn(183, paramType, "<init>", "(Ljava/lang/String;)V", false);
            } else if (PACK_TYPE_BOOLEAN.equals(paramType)) {
                paramType = Type.getInternalName(Boolean.class);
                methodVisitor.visitTypeInsn(187, paramType);
                methodVisitor.visitInsn(89);
                this.commonSet(methodVisitor, i);
                methodVisitor.visitMethodInsn(182, "java/lang/Object", "toString", "()Ljava/lang/String;", false);
                methodVisitor.visitMethodInsn(183, paramType, "<init>", "(Ljava/lang/String;)V", false);
            } else if (PACK_TYPE_SHORT.equals(paramType)) {
                paramType = Type.getInternalName(Short.class);
                methodVisitor.visitTypeInsn(187, paramType);
                methodVisitor.visitInsn(89);
                this.commonSet(methodVisitor, i);
                methodVisitor.visitMethodInsn(182, "java/lang/Object", "toString", "()Ljava/lang/String;", false);
                methodVisitor.visitMethodInsn(183, paramType, "<init>", "(Ljava/lang/String;)V", false);
            } else if (PACK_TYPE_FLOAT.equals(paramType)) {
                paramType = Type.getInternalName(Float.class);
                methodVisitor.visitTypeInsn(187, paramType);
                methodVisitor.visitInsn(89);
                this.commonSet(methodVisitor, i);
                methodVisitor.visitMethodInsn(182, "java/lang/Object", "toString", "()Ljava/lang/String;", false);
                methodVisitor.visitMethodInsn(183, paramType, "<init>", "(Ljava/lang/String;)V", false);
            } else if (PACK_TYPE_DOUBLE.equals(paramType)) {
                paramType = Type.getInternalName(Double.class);
                methodVisitor.visitTypeInsn(187, paramType);
                methodVisitor.visitInsn(89);
                this.commonSet(methodVisitor, i);
                methodVisitor.visitMethodInsn(182, "java/lang/Object", "toString", "()Ljava/lang/String;", false);
                methodVisitor.visitMethodInsn(183, paramType, "<init>", "(Ljava/lang/String;)V", false);
            } else if (TYPE_STRING.equals(paramType)) {
                this.commonSet(methodVisitor, i);
                methodVisitor.visitTypeInsn(192, paramType);
            } else {
                this.commonSet(methodVisitor, i);
                methodVisitor.visitTypeInsn(192, "com/alibaba/fastjson/JSON");
                methodVisitor.visitLdcInsn((Object)Type.getType((String)Type.getDescriptor(parameterTypes[i])));
                methodVisitor.visitMethodInsn(184, "com/alibaba/fastjson/JSONObject", "toJavaObject", "(Lcom/alibaba/fastjson/JSON;Ljava/lang/Class;)Ljava/lang/Object;", false);
                methodVisitor.visitTypeInsn(192, paramType);
            }
            System.out.println("parameterType" + i + ":" + Type.getInternalName(parameterTypes[i]));
        }
        methodVisitor.visitMethodInsn(182, parentClassPath, methodName, Type.getMethodDescriptor((Method)method), false);
        if (method.getReturnType().equals(Void.TYPE)) {
            Label returnNull = new Label();
            methodVisitor.visitLabel(returnNull);
            methodVisitor.visitInsn(1);
        }
        methodVisitor.visitInsn(176);
        Label label3 = new Label();
        methodVisitor.visitLabel(label3);
        methodVisitor.visitLocalVariable("this", generateClassDesc, null, label0, label3, 0);
        methodVisitor.visitLocalVariable("args", "[Ljava/lang/Object;", null, label0, label3, 1);
        methodVisitor.visitLocalVariable("var", parentClassDesc, null, label1, label3, 2);
        methodVisitor.visitMaxs(2 + parameterTypes.length, 3);
        methodVisitor.visitEnd();
        classWriter.visitEnd();
        byte[] classBytes = classWriter.toByteArray();
        LoggerUtil.debug((String)"class generated,name:{}", (Object[])new Object[]{generateClassName});
        Class<?> generateClass = this.asmClassLoader.defineClassPublic(defineClassPath, classBytes, 0, classBytes.length);
        return generateClass;
    }

    private void commonSet(MethodVisitor methodVisitor, int index) {
        methodVisitor.visitVarInsn(25, 1);
        int insn = 0;
        if (index > 5) {
            methodVisitor.visitIntInsn(16, index);
        } else {
            insn = index + 3;
            methodVisitor.visitInsn(insn);
        }
        methodVisitor.visitInsn(50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void outputClazz(byte[] bytes, String className) {
        FileOutputStream out = null;
        try {
            String pathName = AsmTransferListenerGenerator.class.getResource("/").toURI().getPath() + className + ".class";
            out = new FileOutputStream(new File(pathName));
            out.write(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

