/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.transfer.context;

import com.xdja.transfer.TransferListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class TransferContext {
    private static final String SDK = "_sdk_";
    private static final String UNDERSCORE = "_";
    private static final String LOCAL_TOPIC_PREFIX = "local_";
    private static final String MODULE_CONSUMER_GROUP_SUFFIX = "_con_grp";
    private static final String MODULE_PRODUCER_GROUP_SUFFIX = "_pro_grp";
    private static final Map<String, TransferListener> LISTENERS = new HashMap<String, TransferListener>();
    private String currentPlatfrom;
    private String currentModule;
    private String nameServerAddr;
    private String transferServerAddr;
    private boolean registed = false;
    private final Set<String> platforms = new HashSet<String>();
    public static final ThreadLocal<Boolean> isTransfer = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return true;
        }
    };

    public Boolean getIsTransfer() {
        return isTransfer.get();
    }

    public void setIsTransfer(boolean doTransfer) {
        isTransfer.set(doTransfer);
    }

    public void remove() {
        isTransfer.remove();
    }

    public String getConsumerGroup() throws IllegalArgumentException {
        if (StringUtils.isEmpty((CharSequence)this.currentModule)) {
            throw new IllegalArgumentException("The current module is not set.");
        }
        return this.currentPlatfrom + SDK + this.currentModule + MODULE_CONSUMER_GROUP_SUFFIX;
    }

    public String getProducerGroup() throws IllegalArgumentException {
        if (StringUtils.isEmpty((CharSequence)this.currentModule)) {
            throw new IllegalArgumentException("The current module is not set.");
        }
        return this.currentPlatfrom + SDK + this.currentModule + MODULE_PRODUCER_GROUP_SUFFIX;
    }

    public String getCurrentPlatfrom() {
        return this.currentPlatfrom;
    }

    public void setCurrentPlatfrom(String currentPlatfrom) {
        this.currentPlatfrom = currentPlatfrom;
    }

    public String getCurrentModule() {
        return this.currentModule;
    }

    public void setCurrentModule(String currentModule) {
        this.currentModule = currentModule;
    }

    public String getSubscribeTopic() throws IllegalArgumentException {
        if (StringUtils.isEmpty((CharSequence)this.currentModule)) {
            throw new IllegalArgumentException("The current module is not set.");
        }
        return LOCAL_TOPIC_PREFIX + this.currentModule;
    }

    public String getSendMessgeTopic() throws IllegalArgumentException {
        if (StringUtils.isEmpty((CharSequence)this.currentPlatfrom)) {
            throw new IllegalArgumentException("The current platform is not set.");
        }
        if (StringUtils.isEmpty((CharSequence)this.currentModule)) {
            throw new IllegalArgumentException("The current module is not set.");
        }
        return this.currentPlatfrom + UNDERSCORE + this.currentModule;
    }

    public String getNameServerAddr() {
        return this.nameServerAddr;
    }

    public void setNameServerAddr(String nameServerAddr) {
        this.nameServerAddr = nameServerAddr;
    }

    public void setTransferServerAddr(String transferServerAddr) {
        this.transferServerAddr = transferServerAddr;
    }

    public String getRegisterApiAddr() {
        String apiPath = "/transfer/api/module";
        if (this.transferServerAddr.startsWith("http")) {
            return this.transferServerAddr + apiPath;
        }
        return "http://" + this.transferServerAddr + apiPath;
    }

    public String getSupportedPlatformsAddr() {
        String apiPath = "/transfer/api/platforms";
        if (this.transferServerAddr.startsWith("http")) {
            return this.transferServerAddr + apiPath;
        }
        return "http://" + this.transferServerAddr + apiPath;
    }

    public boolean isRegisted() {
        return this.registed;
    }

    public void setRegisted(boolean registed) {
        this.registed = registed;
    }

    public void addListener(String flag, TransferListener listener) {
        LISTENERS.put(flag, listener);
    }

    public TransferListener getListener(String flag) {
        return LISTENERS.get(flag);
    }

    public Set<String> getPlatforms() {
        return this.platforms;
    }

    public void setPlatforms(Set<String> newPlatforms) {
        if (!this.platforms.isEmpty()) {
            this.platforms.clear();
        }
        this.platforms.addAll(newPlatforms);
    }
}

