/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.transfer.mq;

import com.alibaba.fastjson.JSON;
import com.xdja.common.logger.LoggerUtil;
import com.xdja.transfer.constant.ExecuteTransferRequestStatus;
import com.xdja.transfer.context.TransferContext;
import com.xdja.transfer.entity.TransferMessage;
import java.io.UnsupportedEncodingException;
import org.apache.rocketmq.common.message.MessageExt;

public abstract class BaseMessageListenerImpl {
    protected TransferMessage createTransferMessage(MessageExt msg) throws UnsupportedEncodingException {
        TransferMessage tmsg = (TransferMessage)JSON.parseObject((String)this.getMsgBody(msg), TransferMessage.class);
        if (tmsg == null) {
            LoggerUtil.warn((String)"Failed to parse msgBody into TransferMessage object.", (Object[])new Object[0]);
            return null;
        }
        return tmsg;
    }

    protected ExecuteTransferRequestStatus executeTransferRequest(TransferContext context, TransferMessage tmsg) {
        return context.getListener(tmsg.getFlag()).executeTransferRequest(tmsg.getData());
    }

    private String getMsgBody(MessageExt msg) throws UnsupportedEncodingException {
        String msgBody = new String(msg.getBody(), "UTF-8");
        LoggerUtil.debug((String)"message body:{}", (Object[])new Object[]{msgBody});
        return msgBody;
    }
}

