/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.transfer.mq;

import com.xdja.common.logger.LoggerUtil;
import com.xdja.transfer.context.TransferContext;
import com.xdja.transfer.mq.impl.MessageListenerOrderlyImpl;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;

public class OrderlyConsumer {
    private static final String SUB_EXPRESSION = "*";
    private DefaultMQPushConsumer consumer;

    public static OrderlyConsumer getInstance() {
        return InstanceFactory.instance;
    }

    public void startup(TransferContext context) throws Exception {
        this.consumer = new DefaultMQPushConsumer(context.getConsumerGroup());
        this.consumer.setNamesrvAddr(context.getNameServerAddr());
        this.consumer.setConsumeFromWhere(ConsumeFromWhere.CONSUME_FROM_FIRST_OFFSET);
        this.consumer.subscribe(context.getSubscribeTopic(), SUB_EXPRESSION);
        this.consumer.registerMessageListener((MessageListenerOrderly)new MessageListenerOrderlyImpl(context));
        this.consumer.start();
        LoggerUtil.info((String)"ConsumerOrderly started. [namesrv={}, topic={}]", (Object[])new Object[]{context.getNameServerAddr(), context.getSubscribeTopic()});
    }

    public void shutdown() {
        if (this.consumer != null) {
            this.consumer.shutdown();
        }
    }

    private OrderlyConsumer() {
    }

    private static class InstanceFactory {
        private static final OrderlyConsumer instance = new OrderlyConsumer();

        private InstanceFactory() {
        }
    }
}

