/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.transfer.mq;

import com.xdja.common.logger.LoggerUtil;
import com.xdja.transfer.context.TransferContext;
import com.xdja.transfer.mq.impl.TransactionListenerImpl;
import com.xdja.transfer.util.Utils;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.TransactionListener;
import org.apache.rocketmq.client.producer.TransactionMQProducer;
import org.apache.rocketmq.client.producer.TransactionSendResult;
import org.apache.rocketmq.common.message.Message;

public class TransactionProducer {
    private TransactionMQProducer producer;

    public static TransactionProducer getInstance() {
        return InstanceFactory.instance;
    }

    private TransactionProducer() {
    }

    public void startup(TransferContext context) {
        this.producer = new TransactionMQProducer(context.getProducerGroup());
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(2, 5, 100L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(2000), r -> {
            Thread thread = new Thread(r);
            thread.setName("producer-thread");
            return thread;
        });
        this.producer.setNamesrvAddr(context.getNameServerAddr());
        this.producer.setExecutorService((ExecutorService)executorService);
        this.producer.setTransactionListener((TransactionListener)new TransactionListenerImpl(context));
        this.producer.setDefaultTopicQueueNums(1);
        try {
            this.producer.start();
            LoggerUtil.info((String)"Producer started. [namesrv={}]", (Object[])new Object[]{context.getNameServerAddr()});
        }
        catch (MQClientException e) {
            LoggerUtil.error((String)"Exception detail:{}", (Object[])new Object[]{Utils.getStackTrace(e)});
        }
    }

    public void sendMessageInTransaction(TransferContext context, String tags, String body, Object result) {
        try {
            String topic = context.getSendMessgeTopic();
            Message msg = new Message(topic, tags, body.getBytes("UTF-8"));
            msg.putUserProperty("mod", context.getCurrentModule());
            TransactionSendResult sendResult = this.producer.sendMessageInTransaction(msg, result);
            LoggerUtil.info((String)"The result of message sent to the {}@{} is {}", (Object[])new Object[]{topic, this.producer.getNamesrvAddr(), sendResult.getSendStatus()});
        }
        catch (Exception e) {
            LoggerUtil.error((String)"Exception detail:{}", (Object[])new Object[]{Utils.getStackTrace(e)});
        }
    }

    public void shutdown() {
        this.producer.shutdown();
    }

    private static class InstanceFactory {
        private static final TransactionProducer instance = new TransactionProducer();

        private InstanceFactory() {
        }
    }
}

