/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.transfer.mq.impl;

import com.xdja.common.logger.LoggerUtil;
import com.xdja.transfer.constant.ExecuteTransferRequestStatus;
import com.xdja.transfer.context.TransferContext;
import com.xdja.transfer.entity.TransferMessage;
import com.xdja.transfer.mq.BaseMessageListenerImpl;
import com.xdja.transfer.util.Utils;
import java.util.List;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.common.message.MessageExt;

public class MessageListenerOrderlyImpl
extends BaseMessageListenerImpl
implements MessageListenerOrderly {
    private final TransferContext context;

    public MessageListenerOrderlyImpl(TransferContext context) {
        this.context = context;
    }

    public ConsumeOrderlyStatus consumeMessage(List<MessageExt> msgs, ConsumeOrderlyContext consumeOrderlyContext) {
        if (msgs == null || msgs.isEmpty()) {
            LoggerUtil.warn((String)"msgs is empty", (Object[])new Object[0]);
            return ConsumeOrderlyStatus.SUSPEND_CURRENT_QUEUE_A_MOMENT;
        }
        LoggerUtil.info((String)"##### msgs size:{}", (Object[])new Object[]{msgs.size()});
        ConsumeOrderlyStatus status = ConsumeOrderlyStatus.SUSPEND_CURRENT_QUEUE_A_MOMENT;
        for (MessageExt msg : msgs) {
            try {
                LoggerUtil.info((String)"##### topic:{}, msgId:{},DelayTimeLevel:{},queueId:{}", (Object[])new Object[]{msg.getTopic(), msg.getMsgId(), msg.getDelayTimeLevel(), msg.getQueueId()});
                TransferMessage message = this.createTransferMessage(msg);
                if (message == null) continue;
                ExecuteTransferRequestStatus exeStatus = this.executeTransferRequest(this.context, message);
                switch (exeStatus) {
                    case EXE_SUCCESS: {
                        status = ConsumeOrderlyStatus.SUCCESS;
                        break;
                    }
                    default: {
                        status = ConsumeOrderlyStatus.SUSPEND_CURRENT_QUEUE_A_MOMENT;
                        break;
                    }
                }
            }
            catch (Exception e) {
                LoggerUtil.error((String)"exception detail:{}", (Object[])new Object[]{Utils.getStackTrace(e)});
            }
        }
        return status;
    }
}

