/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.transfer.mq.impl;

import com.alibaba.fastjson.JSON;
import com.xdja.common.logger.LoggerUtil;
import com.xdja.transfer.TransferListener;
import com.xdja.transfer.context.TransferContext;
import com.xdja.transfer.entity.TransferData;
import com.xdja.transfer.entity.TransferMessage;
import com.xdja.transfer.util.Utils;
import org.apache.rocketmq.client.producer.LocalTransactionState;
import org.apache.rocketmq.client.producer.TransactionListener;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageExt;

public class TransactionListenerImpl
implements TransactionListener {
    private final TransferContext transferContext;

    public TransactionListenerImpl(TransferContext transferContext) {
        this.transferContext = transferContext;
    }

    public LocalTransactionState executeLocalTransaction(Message msg, Object data) {
        LocalTransactionState state = LocalTransactionState.UNKNOW;
        try {
            String msgBody = new String(msg.getBody(), "UTF-8");
            LoggerUtil.debug((String)"message body:{}", (Object[])new Object[]{msgBody});
            TransferMessage tmsg = (TransferMessage)JSON.parseObject((String)msgBody, TransferMessage.class);
            tmsg.setTransactionId(msg.getTransactionId());
            TransferListener listener = this.transferContext.getListener(tmsg.getFlag());
            boolean isCommit = listener.executeLocalTransaction(tmsg, (TransferData)data);
            state = isCommit ? LocalTransactionState.COMMIT_MESSAGE : LocalTransactionState.ROLLBACK_MESSAGE;
        }
        catch (Throwable e) {
            LoggerUtil.error((String)"exception detail: {}", (Object[])new Object[]{Utils.getStackTrace(e)});
        }
        return state;
    }

    public LocalTransactionState checkLocalTransaction(MessageExt msg) {
        LocalTransactionState state = LocalTransactionState.ROLLBACK_MESSAGE;
        try {
            String msgBody = new String(msg.getBody(), "UTF-8");
            LoggerUtil.debug((String)"message body:{}", (Object[])new Object[]{msgBody});
            TransferMessage tmsg = (TransferMessage)JSON.parseObject((String)msgBody, TransferMessage.class);
            tmsg.setTransactionId(msg.getTransactionId());
            TransferListener listener = this.transferContext.getListener(tmsg.getFlag());
            boolean isCommit = listener.checkLocalTransaction(tmsg);
            state = isCommit ? LocalTransactionState.COMMIT_MESSAGE : LocalTransactionState.ROLLBACK_MESSAGE;
        }
        catch (Throwable e) {
            LoggerUtil.error((String)"exception detail: {}", (Object[])new Object[]{Utils.getStackTrace(e)});
        }
        return state;
    }
}

