/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.transfer.service.impl;

import com.alibaba.fastjson.JSON;
import com.xdja.common.logger.LoggerUtil;
import com.xdja.transfer.context.TransferContext;
import com.xdja.transfer.entity.Account;
import com.xdja.transfer.entity.TransferMessage;
import com.xdja.transfer.mq.ConcurrentlyConsumer;
import com.xdja.transfer.mq.TransactionProducer;
import com.xdja.transfer.service.TransferService;
import com.xdja.transfer.util.Utils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TransferServiceImpl
implements TransferService {
    private final ConcurrentlyConsumer concurrentlyConsumer = ConcurrentlyConsumer.getInstance();
    private final TransactionProducer producer = TransactionProducer.getInstance();
    private TransferContext context;

    @Override
    public boolean initialize(TransferContext context) {
        this.context = context;
        try {
            this.concurrentlyConsumer.startup(context);
            this.producer.startup(context);
        }
        catch (Exception e) {
            LoggerUtil.error((String)"Exception detail:{}", (Object[])new Object[]{Utils.getStackTrace(e)});
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Set<Account>> accountSorting(List<Account> orgAccounts) {
        HashMap<String, Set<Account>> result = new HashMap<String, Set<Account>>();
        Set<String> platforms = this.context.getPlatforms();
        for (String platform : platforms) {
            HashSet<Account> platformAccountSet = new HashSet<Account>();
            for (Account account : orgAccounts) {
                if (!account.getPlatform().equals(platform)) continue;
                platformAccountSet.add(account);
            }
            result.put(platform, platformAccountSet);
        }
        return result;
    }

    @Override
    public void distribute(String flag, String body, Object result) {
        TransferMessage message = new TransferMessage();
        message.setPlatform(this.context.getCurrentPlatfrom());
        message.setModule(this.context.getCurrentModule());
        message.setFlag(flag);
        message.setData(body);
        this.producer.sendMessageInTransaction(this.context, flag, JSON.toJSONString((Object)message), result);
    }

    @Override
    public void duplicate(String flag, String body, Object result) {
        TransferMessage message = new TransferMessage();
        message.setPlatform(this.context.getCurrentPlatfrom());
        message.setModule(this.context.getCurrentModule());
        message.setFlag(flag);
        message.setData(body);
        this.producer.sendMessageInTransaction(this.context, flag, JSON.toJSONString((Object)message), result);
    }

    @Override
    public void shutdown() {
        this.concurrentlyConsumer.shutdown();
        this.producer.shutdown();
    }
}

