/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.transfer.util;

import com.xdja.common.logger.LoggerUtil;
import com.xdja.transfer.util.Charsets;
import com.xdja.transfer.util.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class HttpUtils {
    public static final int SUCCESS = 200;
    public static final String RESPONSE_CODE = "code";
    public static final String RESPONSE_DATA = "data";
    private static final int HTTP_CODE_400 = 400;
    private static final int CONNECTION_TIMEOUT = 2000;
    private static final int READ_TIMEOUT = 2000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String httpUrl) throws Exception {
        LoggerUtil.info((String)"get url:{}", (Object[])new Object[]{httpUrl});
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = this.getConnection(httpUrl, "GET");
            urlConnection.connect();
            String string = this.readResponse(urlConnection);
            return string;
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String post(String httpUrl, String data) throws Exception {
        String string;
        LoggerUtil.info((String)"post url:{}, data:{}", (Object[])new Object[]{httpUrl, data});
        OutputStream outPut = null;
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = this.getConnection(httpUrl, "POST");
            urlConnection.connect();
            outPut = urlConnection.getOutputStream();
            outPut.write(data.getBytes(StandardCharsets.UTF_8));
            outPut.flush();
            string = this.readResponse(urlConnection);
        }
        catch (Throwable throwable) {
            try {
                if (outPut != null) {
                    outPut.close();
                }
            }
            catch (IOException e) {
                LoggerUtil.error((String)"exception happend! detail:{}", (Object[])new Object[]{Utils.getStackTrace(e)});
            }
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            throw throwable;
        }
        try {
            if (outPut != null) {
                outPut.close();
            }
        }
        catch (IOException e) {
            LoggerUtil.error((String)"exception happend! detail:{}", (Object[])new Object[]{Utils.getStackTrace(e)});
        }
        if (urlConnection != null) {
            urlConnection.disconnect();
        }
        return string;
    }

    private HttpURLConnection getConnection(String httpUrl, String method) throws Exception {
        URL url = new URL(httpUrl);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.setRequestMethod(method);
        urlConnection.setDoOutput(true);
        urlConnection.setDoInput(true);
        urlConnection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        urlConnection.setConnectTimeout(2000);
        urlConnection.setReadTimeout(2000);
        return urlConnection;
    }

    private String readResponse(HttpURLConnection urlConnection) throws Exception {
        InputStream in = urlConnection.getResponseCode() < 400 ? urlConnection.getInputStream() : urlConnection.getErrorStream();
        List<String> lines = this.readLines(in, urlConnection.getContentEncoding());
        StringBuilder strBuf = new StringBuilder();
        for (String line : lines) {
            strBuf.append(line);
        }
        return strBuf.toString();
    }

    private List<String> readLines(InputStream input, String encoding) throws IOException {
        InputStreamReader isReader = new InputStreamReader(input, Charsets.toCharset(encoding));
        BufferedReader bfReader = new BufferedReader(isReader);
        ArrayList<String> list = new ArrayList<String>();
        String line = bfReader.readLine();
        while (line != null) {
            list.add(line);
            line = bfReader.readLine();
        }
        return list;
    }
}

