/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.uaas.sso.client.filter;

import com.xdja.uaas.sso.client.filter.AbstractConfigurationFilter;
import com.xdja.uaas.sso.client.filter.CommonUtils;
import java.util.Arrays;
import java.util.List;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractCasFilter
extends AbstractConfigurationFilter {
    private static final String X_REQUEST_WITH = "x-requested-with";
    private static final String XML_HTTP_REQUEST = "XMLHttpRequest";
    public static final String SSO_SERVER_VALIDATION_URL = "casServerValidationUrl";
    public static final String SSO_SERVER_LOGIN_URL = "casServerLoginUrl";
    public static final String SERVER_INDEX_URL = "serverIndexUrl";
    public static final String WHITE_URL = "whiteList";
    private boolean encodeServiceUrl = true;
    private String service;
    public static final String USER_CREDENTIAL = "userCredential";
    private String serviceParameterName = "redirect_url";
    private List<String> whiteList;
    protected String casServerLoginUrl;

    public final void init(FilterConfig filterConfig) throws ServletException {
        this.setService(this.getPropertyFromInitParams(filterConfig, SERVER_INDEX_URL, null));
        this.log.trace("\u52a0\u8f7d\u672c\u5730\u670d\u52a1\u8df3\u8f6c\u5730\u5740: " + this.service);
        this.setServiceParameterName(this.getPropertyFromInitParams(filterConfig, "serviceParameterName", "redirect_url"));
        this.log.trace("\u52a0\u8f7d\u91cd\u5b9a\u5411\u53c2\u6570\u540d\u79f0: " + this.serviceParameterName);
        this.setEncodeServiceUrl(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "encodeServiceUrl", "true")));
        this.log.trace("\u52a0\u8f7dURL\u5730\u5740\u662f\u5426\u8f6c\u7801: " + this.encodeServiceUrl);
        this.setCasServerLoginUrl(this.getPropertyFromInitParams(filterConfig, SSO_SERVER_LOGIN_URL, null));
        this.log.trace("\u52a0\u8f7dcasServerLoginUrl: " + this.casServerLoginUrl);
        String whiteListStr = this.getPropertyFromInitParams(filterConfig, WHITE_URL, null);
        this.log.trace("\u52a0\u8f7dwhiteList: " + this.whiteList);
        if (whiteListStr != null && whiteListStr.length() > 0) {
            this.setWhiteList(Arrays.asList(whiteListStr.split(",")));
        }
        this.initInternal(filterConfig);
        this.init();
    }

    protected void initInternal(FilterConfig filterConfig) throws ServletException {
    }

    public void init() {
        CommonUtils.assertNotNull(this.serviceParameterName, "\u91cd\u5b9a\u5411\u53c2\u6570\u540d\u79f0\u4e0d\u80fd\u4e3anull.");
        CommonUtils.assertNotNull(this.casServerLoginUrl, "casServerLoginUrl\u4e0d\u80fd\u662f\u7a7a.");
    }

    public void destroy() {
    }

    protected final String constructServiceUrl(HttpServletRequest request, HttpServletResponse response) {
        return CommonUtils.constructServiceUrl(request, response, this.service, USER_CREDENTIAL, this.encodeServiceUrl);
    }

    public final void setService(String service) {
        this.service = service;
    }

    public final void setEncodeServiceUrl(boolean encodeServiceUrl) {
        this.encodeServiceUrl = encodeServiceUrl;
    }

    public String getServiceParameterName() {
        return this.serviceParameterName;
    }

    public void setServiceParameterName(String serviceParameterName) {
        this.serviceParameterName = serviceParameterName;
    }

    public List<String> getWhiteList() {
        return this.whiteList;
    }

    public void setWhiteList(List<String> whiteList) {
        this.whiteList = whiteList;
    }

    public final void setCasServerLoginUrl(String casServerLoginUrl) {
        this.casServerLoginUrl = casServerLoginUrl;
    }

    public boolean isAjaxReq(HttpServletRequest request) {
        return request.getHeader(X_REQUEST_WITH) != null && request.getHeader(X_REQUEST_WITH).equalsIgnoreCase(XML_HTTP_REQUEST);
    }
}

