/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.uaas.sso.client.filter;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.TimeZone;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    private static final Logger logger = LoggerFactory.getLogger(CommonUtils.class);
    static TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }};

    private CommonUtils() {
    }

    public static String formatForUtcTime(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(date);
    }

    public static void assertNotNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertNotEmpty(Collection<?> c, String message) {
        CommonUtils.assertNotNull(c, message);
        if (c.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertTrue(boolean cond, String message) {
        if (!cond) {
            throw new IllegalArgumentException(message);
        }
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isNotEmpty(String string) {
        return !CommonUtils.isEmpty(string);
    }

    public static boolean isBlank(String string) {
        return CommonUtils.isEmpty(string) || string.trim().length() == 0;
    }

    public static boolean isNotBlank(String string) {
        return !CommonUtils.isBlank(string);
    }

    public static String constructRedirectUrl(String casServerLoginUrl, String serviceParameterName, String serviceUrl) {
        try {
            return casServerLoginUrl + (casServerLoginUrl.contains("?") ? "&" : "?") + "timestamp=" + System.currentTimeMillis() + "&" + serviceParameterName + "=" + URLEncoder.encode(serviceUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException var6) {
            throw new RuntimeException(var6);
        }
    }

    public static String constructServiceUrl(HttpServletRequest request, HttpServletResponse response, String service, String artifactParameterName, boolean encode) {
        String returnValue;
        if (CommonUtils.isNotBlank(service)) {
            return encode ? response.encodeURL(service) : service;
        }
        StringBuffer buffer = request.getRequestURL();
        if (CommonUtils.isNotBlank(request.getQueryString())) {
            int location = request.getQueryString().indexOf(artifactParameterName + "=");
            if (location == 0) {
                String returnValue2;
                String string = returnValue2 = encode ? response.encodeURL(buffer.toString()) : buffer.toString();
                if (logger.isDebugEnabled()) {
                    logger.debug("\u751f\u6210\u7b2c\u4e09\u65b9\u8bf7\u6c42\u5730\u5740: " + returnValue2);
                }
                return returnValue2;
            }
            buffer.append("?");
            if (location == -1) {
                buffer.append(request.getQueryString());
            } else if (location > 0) {
                int actualLocation = request.getQueryString().indexOf("&" + artifactParameterName + "=");
                if (actualLocation == -1) {
                    buffer.append(request.getQueryString());
                } else if (actualLocation > 0) {
                    buffer.append(request.getQueryString().substring(0, actualLocation));
                }
            }
        }
        String string = returnValue = encode ? response.encodeURL(buffer.toString()) : buffer.toString();
        if (logger.isDebugEnabled()) {
            logger.debug("\u751f\u6210\u7b2c\u4e09\u65b9\u8bf7\u6c42\u5730\u5740: " + returnValue);
        }
        return returnValue;
    }

    public static String safeGetParameter(HttpServletRequest request, String parameter) {
        if ("POST".equals(request.getMethod()) && "logoutRequest".equals(parameter)) {
            logger.debug("safeGetParameter called on a POST HttpServletRequest for LogoutRequest.  Cannot complete check safely.  Reverting to standard behavior for this Parameter");
            return request.getParameter(parameter);
        }
        return request.getQueryString() != null && request.getQueryString().contains(parameter) ? request.getParameter(parameter) : null;
    }

    public static String encode(String str) {
        try {
            return URLEncoder.encode(str, "utf-8");
        }
        catch (Exception exception) {
            return null;
        }
    }
}

