/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.uaas.sso.client.filter;

import com.alibaba.fastjson.JSON;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieUtils {
    private static final Logger logger = LoggerFactory.getLogger(CookieUtils.class);

    public static String getCookieValue(HttpServletRequest request, String cookieName, boolean isDecoder) {
        Cookie[] cookieList = request.getCookies();
        if (cookieList == null || cookieName == null) {
            return null;
        }
        String retValue = null;
        try {
            int len = cookieList.length;
            for (int i = 0; i < len; ++i) {
                if (!cookieList[i].getName().equals(cookieName)) continue;
                retValue = isDecoder ? URLDecoder.decode(cookieList[i].getValue(), "UTF-8") : cookieList[i].getValue();
                break;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return retValue;
    }

    public static void addCookie(HttpServletResponse response, String name, Object object, Integer maxAge, boolean isEncode) {
        try {
            String tmp = object instanceof String ? (String)object : JSON.toJSONString((Object)object);
            String v = isEncode ? URLEncoder.encode(tmp, "UTF-8") : tmp;
            String cookieValue = name + "=" + v + ";path=/";
            if (maxAge != null) {
                cookieValue = cookieValue + ";Max-Age=" + maxAge;
            }
            response.addHeader("Set-Cookie", cookieValue);
        }
        catch (Exception e) {
            logger.error(" -------\u6dfb\u52a0cookie \u5931\u8d25\uff01--------" + e.getMessage());
        }
    }
}

