/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.uaas.sso.client.filter;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static Logger logger = LoggerFactory.getLogger(HttpUtils.class);
    private static HttpClientBuilder clientBuilder = HttpClientBuilder.create();

    public static GetUtil createGet(String url) {
        return new GetUtil(url);
    }

    public static PostUtil createPost(String url) {
        return new PostUtil(url);
    }

    public static PostUtil createPost(String url, ContentType contentType) {
        return new PostUtil(url, contentType);
    }

    public static FormUtil createForm(String url) {
        return new FormUtil(url);
    }

    private static LayeredConnectionSocketFactory getSSLSocketFactory() {
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    return true;
                }
            }).build();
            return new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static CloseableHttpClient build(HttpRequestBase requestBase) {
        if (requestBase.getURI().getScheme().equalsIgnoreCase("https")) {
            clientBuilder.setSSLSocketFactory(HttpUtils.getSSLSocketFactory());
        }
        return clientBuilder.build();
    }

    private static ResponseWrap exec(HttpRequestBase requestBase) {
        ResponseWrap responseWrap = null;
        try {
            CloseableHttpClient httpClient = HttpUtils.build(requestBase);
            HttpClientContext context = HttpClientContext.create();
            CloseableHttpResponse execute = httpClient.execute((HttpUriRequest)requestBase, (HttpContext)context);
            responseWrap = new ResponseWrap(httpClient, requestBase, execute, context);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return responseWrap;
    }

    public static class ResponseWrap {
        private CloseableHttpClient httpClient;
        private HttpRequestBase request;
        private CloseableHttpResponse response;
        private HttpClientContext context;
        private HttpEntity entity;

        ResponseWrap(CloseableHttpClient httpClient, HttpRequestBase request, CloseableHttpResponse response, HttpClientContext context) {
            this.httpClient = httpClient;
            this.request = request;
            this.response = response;
            this.context = context;
            try {
                HttpEntity entity = response.getEntity();
                this.entity = null != entity ? new BufferedHttpEntity(entity) : new BasicHttpEntity();
                EntityUtils.consume((HttpEntity)entity);
                this.response.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }

        public String getString() {
            try {
                return EntityUtils.toString((HttpEntity)this.entity, (Charset)Consts.UTF_8);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        public byte[] getBytes() {
            try {
                return EntityUtils.toByteArray((HttpEntity)this.entity);
            }
            catch (IOException | ParseException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        public InputStream getInputStream() {
            try {
                return this.entity.getContent();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        public int statusCode() {
            return this.response.getStatusLine().getStatusCode();
        }

        public String getHeaderValue(String key) {
            Header[] headers = this.response.getHeaders(key);
            if (headers == null || headers.length == 0) {
                return null;
            }
            return headers[0].getValue();
        }
    }

    public static class FormUtil {
        private HttpPost httpPost;
        private MultipartEntityBuilder builder;

        public FormUtil(String url) {
            this.httpPost = new HttpPost(url);
            this.builder = MultipartEntityBuilder.create();
            this.builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        }

        public FormUtil addParameter(String name, String value) {
            this.builder.addTextBody(name, value, ContentType.TEXT_PLAIN.withCharset(Charset.forName("UTF-8")));
            return this;
        }

        public FormUtil addParameters(Map<String, String> parameters) {
            Set<String> keySet = parameters.keySet();
            for (String key : keySet) {
                this.addParameter(key, parameters.get(key));
            }
            return this;
        }

        public FormUtil addParameter(String name, byte[] bytes) {
            this.builder.addBinaryBody(name, bytes);
            return this;
        }

        public FormUtil addParameter(String name, byte[] bytes, ContentType contentType, String filename) {
            this.builder.addBinaryBody(name, bytes, contentType, filename);
            return this;
        }

        public FormUtil addParameter(String name, File file, ContentType contentType, String fileName) {
            this.builder.addBinaryBody(name, file, contentType, fileName);
            return this;
        }

        public FormUtil setBoundary(String boundary) {
            this.builder.setBoundary(boundary);
            return this;
        }

        public ResponseWrap execute() {
            HttpEntity httpEntity = this.builder.build();
            this.httpPost.setEntity(httpEntity);
            return HttpUtils.exec((HttpRequestBase)this.httpPost);
        }
    }

    public static class PostUtil {
        private HttpPost httpPost;
        private EntityBuilder entityBuilder;

        public PostUtil(String url) {
            this.httpPost = new HttpPost(url);
            this.entityBuilder = EntityBuilder.create().setParameters(new ArrayList());
        }

        public PostUtil(String url, ContentType contentType) {
            this(url);
            this.entityBuilder.setContentType(contentType);
        }

        public PostUtil addHeader(String name, String value) {
            this.httpPost.addHeader(name, value);
            return this;
        }

        public PostUtil addHeader(Map<String, String> headers) {
            if (null != headers) {
                for (String key : headers.keySet()) {
                    this.httpPost.addHeader(key, headers.get(key));
                }
            }
            return this;
        }

        public PostUtil addParameter(String param, String value) {
            this.entityBuilder.getParameters().add(new BasicNameValuePair(param, value));
            return this;
        }

        public PostUtil addParameters(Map<String, String> parameters) {
            Set<String> keys = parameters.keySet();
            for (String key : keys) {
                this.addParameter(key, parameters.get(key));
            }
            return this;
        }

        public PostUtil addJsonBody(Object object) {
            this.entityBuilder.setContentType(ContentType.APPLICATION_JSON);
            this.entityBuilder.setContentEncoding("utf-8");
            if (object instanceof String) {
                this.entityBuilder.setBinary(((String)object).getBytes());
            } else {
                this.entityBuilder.setBinary(JSON.toJSONString((Object)object).getBytes());
            }
            return this;
        }

        public PostUtil addBody(byte[] bytes) {
            this.entityBuilder.setBinary(bytes);
            return this;
        }

        public ResponseWrap execute() {
            HttpEntity httpEntity = this.entityBuilder.build();
            this.httpPost.setEntity(httpEntity);
            return HttpUtils.exec((HttpRequestBase)this.httpPost);
        }
    }

    public static class GetUtil {
        private HttpGet httpGet;
        private URIBuilder uriBuilder;
        private RequestConfig.Builder requestConfigBuilder;

        private GetUtil(String url) {
            this.httpGet = new HttpGet(url);
            this.uriBuilder = new URIBuilder(this.httpGet.getURI());
            this.requestConfigBuilder = RequestConfig.custom();
        }

        public GetUtil addHeader(String name, String value) {
            this.httpGet.addHeader(name, value);
            return this;
        }

        public GetUtil addHeaders(Map<String, String> headers) {
            if (null != headers && !headers.isEmpty()) {
                for (String key : headers.keySet()) {
                    this.httpGet.addHeader(key, headers.get(key));
                }
            }
            return this;
        }

        public GetUtil addParameter(String param, String value) {
            this.uriBuilder.setParameter(param, value);
            return this;
        }

        public GetUtil setConnectTimeOut(int timeout) {
            this.requestConfigBuilder.setConnectTimeout(timeout);
            return this;
        }

        public GetUtil setSocketTimeout(int timeout) {
            this.requestConfigBuilder.setSocketTimeout(timeout);
            return this;
        }

        public ResponseWrap execute() {
            try {
                URI uri = new URI(this.uriBuilder.build().toString().replace("%3F", "?"));
                this.httpGet.setURI(uri);
                this.httpGet.setConfig(this.requestConfigBuilder.build());
            }
            catch (URISyntaxException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            return HttpUtils.exec((HttpRequestBase)this.httpGet);
        }
    }
}

