/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.uaas.sso.client.filter;

import com.alibaba.fastjson.JSON;
import com.xdja.uaas.sso.client.filter.AbstractCasFilter;
import com.xdja.uaas.sso.client.filter.AuthOrValiError;
import com.xdja.uaas.sso.client.filter.CommonUtils;
import com.xdja.uaas.sso.client.filter.CookieUtils;
import com.xdja.uaas.sso.client.filter.HttpUtils;
import com.xdja.uaas.sso.client.filter.ValidationException;
import com.xdja.uaas.sso.client.filter.ValidationReq;
import com.xdja.uaas.sso.client.filter.ValidationResp;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ValidationFilter
extends AbstractCasFilter {
    public static final String CAS_PERSON_INFO = "cas_person_info";
    private static final String APP_CREDENTIAL = "appCredential";
    private static final String SUCCESS = "0";
    private String casServerValidationUrl;

    public String getCasServerValidationUrl() {
        return this.casServerValidationUrl;
    }

    public void setCasServerValidationUrl(String casServerValidationUrl) {
        this.casServerValidationUrl = casServerValidationUrl;
    }

    @Override
    protected void initInternal(FilterConfig filterConfig) throws ServletException {
        super.initInternal(filterConfig);
        this.setCasServerValidationUrl(this.getPropertyFromInitParams(filterConfig, "casServerValidationUrl", null));
        this.log.trace("\u52a0\u8f7d CasServerValidationUrl: " + this.casServerValidationUrl);
    }

    @Override
    public void init() {
        super.init();
        CommonUtils.assertNotNull(this.casServerValidationUrl, "casServerValidationUrl\u4e0d\u80fd\u4e3a\u7a7a.");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        List<String> whiteList = this.getWhiteList();
        if (whiteList != null && !whiteList.isEmpty() && whiteList.contains(request.getServletPath())) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String userCredential = CommonUtils.safeGetParameter(request, "userCredential");
        if (CommonUtils.isBlank(userCredential)) {
            userCredential = CookieUtils.getCookieValue(request, "userCredential", false);
        }
        if (CommonUtils.isBlank(userCredential)) {
            userCredential = request.getHeader("userCredential");
        }
        String appCredential = request.getHeader(APP_CREDENTIAL);
        if (CommonUtils.isBlank(userCredential)) {
            this.log.warn("\u6ca1\u6709\u7528\u6237\u51ed\u8bc1\u4fe1\u606f,\u6821\u9a8c\u5931\u8d25");
            this.redirectToLogin(request, response);
            return;
        }
        ValidationResp.IdentifyPersonInfoDTO personInfo = this.validate(userCredential, appCredential);
        if (personInfo == null) {
            CookieUtils.addCookie(response, CAS_PERSON_INFO, personInfo, 0, true);
            CookieUtils.addCookie(response, "userCredential", userCredential, 0, false);
            this.fail(request, response);
            this.redirectToLogin(request, response);
        } else {
            request.getSession().setAttribute("SSO_USER", (Object)personInfo.getPersonCode());
            CookieUtils.addCookie(response, CAS_PERSON_INFO, personInfo, null, true);
            CookieUtils.addCookie(response, "userCredential", userCredential, null, false);
            this.success(request, response, userCredential);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected void success(HttpServletRequest request, HttpServletResponse response, String userCredential) {
    }

    protected void fail(HttpServletRequest request, HttpServletResponse response) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String serviceUrl = this.constructServiceUrl(request, response);
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u8bbf\u95ee\u5730\u5740: " + serviceUrl);
        }
        String urlToRedirectTo = CommonUtils.constructRedirectUrl(this.casServerLoginUrl, this.getServiceParameterName(), serviceUrl);
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u91cd\u5b9a\u5411\u5230 \"" + urlToRedirectTo + "\"");
        }
        if (this.isAjaxReq(request)) {
            response.setStatus(401);
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/json;charset=UTF-8");
            AuthOrValiError error = new AuthOrValiError();
            error.setMessage("Ajax\u8bf7\u6c42\u91cd\u5b9a\u5411");
            error.setSsoUrl(urlToRedirectTo);
            try (PrintWriter writer = null;){
                writer = response.getWriter();
                writer.write(JSON.toJSONString((Object)error));
                writer.flush();
            }
        } else {
            response.sendRedirect(urlToRedirectTo);
        }
    }

    public ValidationResp.IdentifyPersonInfoDTO validate(String userCredential, String appCredential) throws ValidationException {
        HttpUtils.ResponseWrap responseWrap;
        String validationUrl = this.casServerValidationUrl;
        HashMap<String, String> mapHeader = new HashMap<String, String>(2);
        mapHeader.put("userCredential", userCredential);
        if (appCredential != null && appCredential.length() > 0) {
            mapHeader.put(APP_CREDENTIAL, appCredential);
        }
        ValidationReq req = new ValidationReq();
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u6821\u9a8c\u7528\u6237\u51ed\u8bc1>>>url:\u3010{}\u3011,Header:\u3010{}\u3011,param:\u3010{}\u3011", new Object[]{validationUrl, JSON.toJSONString(mapHeader), JSON.toJSONString((Object)req)});
        }
        if ((responseWrap = HttpUtils.createGet(validationUrl).addHeaders(mapHeader).execute()) == null) {
            this.log.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25:\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a,url:\u3010{}\u3011,Header:\u3010{}\u3011,param:\u3010{}\u3011", new Object[]{validationUrl, JSON.toJSONString(mapHeader), JSON.toJSONString((Object)req)});
            throw new ValidationException("\u9a8c\u8bc1\u670d\u52a1\u65e0\u54cd\u5e94");
        }
        if (200 != responseWrap.statusCode()) {
            this.log.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25url:\u3010{}\u3011,Header:\u3010{}\u3011,param:\u3010{}\u3011,:\u8fd4\u56deHTTP\u72b6\u6001\u7801\u9519\u8bef{},", new Object[]{validationUrl, JSON.toJSONString(mapHeader), JSON.toJSONString((Object)req), responseWrap.statusCode()});
            throw new ValidationException("\u8fd4\u56deHTTP\u72b6\u6001\u7801\u9519\u8bef" + responseWrap.statusCode());
        }
        String result = responseWrap.getString();
        ValidationResp resp = (ValidationResp)JSON.parseObject((String)result, ValidationResp.class);
        if (SUCCESS.equals(resp.getCode())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("\u6821\u9a8c\u7528\u6237\u51ed\u8bc1>>>url:\u3010{}\u3011,Header:\u3010{}\u3011,param:\u3010{}\u3011, \u6821\u9a8c\u901a\u8fc7", new Object[]{validationUrl, JSON.toJSONString(mapHeader), JSON.toJSONString((Object)req)});
            }
            return resp.getIdentifyPersonInfo();
        }
        this.log.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25url:\u3010{}\u3011,Header:\u3010{}\u3011,param:\u3010{}\u3011,:\u8fd4\u56de\u4e1a\u52a1\u72b6\u6001\u7801\u9519\u8bef\uff1a{},\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{validationUrl, JSON.toJSONString(mapHeader), JSON.toJSONString((Object)req), resp.getCode(), resp.getMessage()});
        return null;
    }

    private String constructValidationUrl(String userCredential, String serviceUrl) {
        HashMap<String, String> urlParameters = new HashMap<String, String>(2);
        this.log.debug("Placing URL parameters in map.");
        urlParameters.put("userCredential", userCredential);
        urlParameters.put(this.getServiceParameterName(), this.encodeUrl(serviceUrl));
        StringBuilder buffer = new StringBuilder(urlParameters.size() * 10 + this.casServerValidationUrl.length() + 1);
        buffer.append(this.casServerValidationUrl);
        int i = 0;
        for (Map.Entry entry : urlParameters.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value == null) continue;
            buffer.append(i++ == 0 && !this.casServerValidationUrl.contains("?") ? "?" : "&");
            buffer.append(key);
            buffer.append("=");
            buffer.append(value);
        }
        return buffer.toString();
    }

    private String encodeUrl(String url) {
        if (url == null) {
            return null;
        }
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException var3) {
            return url;
        }
    }
}

